/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package util;

import java.util.*;
import javax.swing.*;
import DrawTop.*;
import shape.*;
import textBox.*;

public class ContainerManager {

    private ArrayList ContainerList;
    private int serialNumber = 0;
    private Vector workVector = new Vector();
    private boolean undoSetup = false;
    private boolean undoEdit = false;
    private ArrayList BackupContainerList = new ArrayList();
    public static int debug = 0;

    public ContainerManager() {
        this.ContainerList = new ArrayList();
    }

    public int getUniqueSerialNumber() {
        int size=this.ContainerList.size();
        if(size==0) {
            this.serialNumber=0;
            return 0;
        } else {
            this.serialNumber=Math.max(this.getMaxSerialNumber()+1, this.serialNumber+1);
			        if (debug > 0) System.out.println(">> ContainerManager.getUniqueSerialNumber "
                    + "MaxSerialNumber=" + this.serialNumber);
            return this.serialNumber;
        }
    }

    private int getMaxSerialNumber() {
        int maxNumber = 0;
        for (int i = 0; i < this.ContainerList.size(); i++) {
            ShapeContainer container = (ShapeContainer) this.ContainerList.get(i);
            int num = container.getSerialNumber();
            if (num > maxNumber) {
                maxNumber = num;
            }
            if (container.getContainerType() == ShapeContainer.GROUP) {
                GroupElement child = (GroupElement) container.getElement();
                ShapeContainer[] children = child.getGroupedContainers();
                int childrenSize = 0;
                if (children != null) {
                    childrenSize = children.length;
                }
                for (int j = 0; j < childrenSize; j++) {
                    num = children[j].getSerialNumber();
                    if (num > maxNumber) {
                        maxNumber = num;
                    }
                }
            }
        }
        if (debug > 0) System.out.println(">> ContainerManager.getMaxSerialNumber "
                    + "MaxSerialNumber=" + maxNumber);
        return maxNumber;
    }
    
    private int getSerialNumber(String shapeId) {
        int num = -1;
        if (shapeId == null || shapeId.equals("")) {
            return num;
        }
        int start = shapeId.lastIndexOf("-");
        int end = shapeId.lastIndexOf(")");
        String subStr = shapeId.substring(start + 1, end);
        subStr = subStr.replace(" ", "");
        num = Integer.parseInt(subStr);
        if(debug>0) System.out.println("getSerialNumber(String) num="+num);
        return num;
    }
    
    public ArrayList getContainerList() {
        ArrayList arrayList = new ArrayList();
        int size = ContainerList.size();
        for (int i = 0; i < size; i++) {
            arrayList.add(ContainerList.get(i));
        }
        return arrayList;
    }


    public void setContainerList(ArrayList ContainerList) {
        this.makeAllTextBoxesUneditable();
        this.ContainerList = ContainerList;
        if(this.isDuplicatedNumber()){
            String message = "Warning: The shapeId numbers are Duplicated!"
                    + "\nContact the author!";
            JOptionPane.showConfirmDialog(ObjectTable.getDrawMain(),message);
            System.err.println(message);
        }
    }
    
    public boolean isDuplicatedNumber(){
        int size=this.size();
        int[] numbers=new int[size];
        for(int i=0;i<size;i++){
            ShapeContainer container=(ShapeContainer)this.ContainerList.get(i);
            String shapeId=container.getShapeId();
            int id0=shapeId.indexOf("-");
            int id1=shapeId.indexOf(")");
            String num=shapeId.substring(id0+1, id1);
            numbers[i]=(new Integer(num)).intValue();
        }
        
        boolean duplicated=false;
        for(int i=0;i<size;i++){
            for(int j=0;j<i;j++){
                if(numbers[j]==numbers[i]){
                    duplicated=true;
                    break;
                }
            }
        }
        return duplicated;
    }

    public int size() {
        return this.ContainerList.size();
    }

    public void clear() {
        this.ContainerList.clear();
        //this.SerialNumber = 0;
    }

    private void setContainerIndex() {
        int size=this.ContainerList.size();
        for(int i=0;i<size;i++){
            ShapeContainer container=(ShapeContainer)this.ContainerList.get(i);
            container.setContainerIndex(i);
        }
    }

    private int getContainerIndex(ShapeContainer container) {
        return ContainerList.indexOf(container);
    }

    private boolean validShapeId(ShapeContainer container) {
        String shapeId = "";
        boolean valid = true;
        ShapeContainer[] containers = container.getGroupedContainers();
        for (int i = 0; i < containers.length; i++) {
            shapeId = containers[i].getShapeId();
            if (shapeId == null || shapeId.equals("")) {
                valid = false;
                System.err.println("*** Error ContainerManager.validShapeId:  Null or blank shapeId"
                        + containers[i].toShortString());
            }
        }
        return valid;
    }

    public boolean addContainer(ShapeContainer container) {
        if (container == null) {
            System.err.println("*** Error in ContainerManager.addContainer"
                    + ", container=null");
            return false;
        }
        String shapeId=container.getShapeId();
        ShapeContainer anotherContainer=null;
        for(int i=0;i<this.ContainerList.size();i++){
            ShapeContainer shapeContainer=(ShapeContainer)this.ContainerList.get(i);
            if(shapeContainer.getShapeId().equals(shapeId)){
                anotherContainer=shapeContainer;
                break;
            }
        }
        if(anotherContainer==null){
            this.ContainerList.add(container);
        } else {
            System.err.println("*** Error ContainerManager.addContainer"
                    + ", The container of the same shapeId was found in the List"
                    +"  shapeId="+container.getShapeId());
            return false;
        }
        this.setContainerIndex();
        this.validShapeId(container);

        if (this.undoSetup) {
            this.undoSetupOfAddOrDelete(UndoConstants.ADD, container);
        }
        return true;
    }

    public boolean addContainer(int index, ShapeContainer container) {
        if (index <0 ) {
            System.err.println("*** Error ContainerManager.addContainer with index"
                    + ", index="+index);
            return false;
        }
       
        if (index <= ContainerList.size()) {
            ContainerList.add(index, container);
        } else {
            ContainerList.add(container);
            System.err.println("*** Warning in ContainerManager.addContainer with index"
                   + ", index out of bound, index=" + index
                   + ", ContainerList size=" + ContainerList.size());
        }
        this.setContainerIndex();
            //this.setContainerIndex(container, "addContainer(index, container)");
        this.validShapeId(container);
        
        if (this.undoSetup) {
            this.undoSetupOfAddOrDelete(UndoConstants.ADD, container);
        }
        if (debug > 0) {
            System.out.println(" Manager.addContainer"
                    + ", container=" + container.getShapeId());
            printContainers("ContainerManager.addContainer");
        }
        return true;
    }

    public boolean deleteContainer(ShapeContainer container) {
        if (container == null) {
            System.err.println("*** Error ContainerManager.deleteContainer"
                    + ", container=null");
            return false;
        }
        //this.setContainerIndex(container, "deleteContainer(container)");
        boolean removed = ContainerList.remove(container);
        if (!removed) {
            System.err.println("*** Error ContainerManager.deleteContainer: Not removed"
                    + " container=" + container.getShapeId() + ", container index=" + container.getContainerIndex()
                    + ", removed=" + removed);
            System.out.println(this.toString());
        }
        this.setContainerIndex();
        if (this.undoSetup && removed) {
            this.undoSetupOfAddOrDelete(UndoConstants.DELETE, container);
        }
        //int size=this.ContainerList.size();
        //if(size==0) this.SerialNumber=0;
        return removed;
    }

    public boolean deleteContainer(int index) {
        ShapeContainer container = (ShapeContainer) ContainerList.get(index);
        //this.setContainerIndex(container, "deleteContainer(index)");
        boolean removed = false;
        if (index >= 0) {
            removed = ContainerList.remove(container);
        }
        if (!removed) {
            System.err.println("*** Error ContainerManager.deleteContainer(index):  Not removed"
                    + " container=" + container.getShapeId() + ", container index=" + container.getContainerIndex()
                    + ", removed=" + removed);
            System.out.println(this.toString());
        }
        this.setContainerIndex();
        if (this.undoSetup && removed) {
            this.undoSetupOfAddOrDelete(UndoConstants.DELETE, container);
        }
        //int size=this.ContainerList.size();
        //if(size==0) this.SerialNumber=0;
        return removed;
    }

    public boolean deleteContainer(String shapeId) {
        ShapeContainer target = null;
        int size = ContainerList.size();
        int isave=-1;
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) ContainerList.get(i);
            if (container.getSerialNumber()
                    == this.getSerialNumber(shapeId)) {
                target = container;
                //this.setContainerIndex(container, "getContainer(shapeId)");
                isave=i;
                 break;
            }
        }
        boolean removed=false;
        if(isave>=0) {
            ContainerList.remove(isave);
            removed=true;
        }
        if (!removed) {
            System.err.println("*** Error ContainerManager.deleteContainer(shapeId): Not removed"
                    + " shapeId=" + shapeId  + ", removed=" + removed);
        }
        this.setContainerIndex();
        if (this.undoSetup && removed) {
            this.undoSetupOfAddOrDelete(UndoConstants.DELETE, target);
        }
        //size=this.ContainerList.size();
        //if(size==0) this.SerialNumber=0;
        return removed;
    }

    public ShapeContainer getContainer(int index) {
        ShapeContainer container = (ShapeContainer) ContainerList.get(index);
        //this.setContainerIndex(container, "getContainer(index)");
        if (this.undoSetup) {
            this.backup(container);
        }
        return container;
    }
   
    public ShapeContainer getContainer(String shapeId) {
        if (shapeId.equals("")) {
            System.err.println("*** Error ContainerManager.getContainer:"
                    + " shapeId=null");
            return null;
        }
        ShapeContainer target = null;
        int size = ContainerList.size();
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) ContainerList.get(i);
            ShapeContainer[] children = container.getGroupedContainers();
            for (int j = 0; j < children.length; j++) {
                if (children[j].getSerialNumber()
                        == this.getSerialNumber(shapeId)) {
                    target = children[j];
                    //this.setContainerIndex(container, "getContainer(shapeId)");
                    break;
                }
            }
        }
        if (target == null) {
            System.err.println("*** Error ContainerManager.getContainer(shapeId)"
                    + ": Container of shapeId not found  shapeId=" + shapeId
                    +", serial number="+this.getSerialNumber(shapeId));
        }
        if (this.undoSetup) {
            this.backup(target);
            this.backup(target.getTopParent());
        }
        return target;
    }

    public ShapeContainer[] getContainers() {
        int size = ContainerList.size();
        ShapeContainer[] containers = new ShapeContainer[size];
        for (int i = 0; i < size; i++) {
            containers[i] = (ShapeContainer) ContainerList.get(i);
            //this.setContainerIndex(containers[i], "getContainers()");
        }
        if (this.undoSetup) {
            this.backup(containers);
        }
        return containers;
    }

    public ShapeContainer[] getSelectedContainers() {
        workVector.clear();
        int size = ContainerList.size();
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) ContainerList.get(i);
            if (container.isSelected()) {
                workVector.add(container);
            }
        }
        size = workVector.size();
        ShapeContainer[] containers = new ShapeContainer[size];
        for (int i = 0; i < size; i++) {
            containers[i] = (ShapeContainer) workVector.get(i);
            //this.setContainerIndex(containers[i], "getSelectedContainers()");
        }
        if (this.undoSetup) {
            this.backup(containers);
		}
		if(debug>0) printShapeIds("** ContainerManager.getSelectedContainers", containers);
        return containers;
    }
	

    public Vector getAllShapeContainers() {
        this.workVector.clear();
        int size = ContainerList.size();
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) ContainerList.get(i);
            ShapeContainer[] children = container.getGroupedContainers();
            for (int j = 0; j < children.length; j++) {
                this.workVector.add(children[j]);
            }
        }
        return this.workVector;
    }

    public ShapeContainer[] getAllSigleShapeContainers(boolean selectedOnly) {
        workVector.clear();
        int size = ContainerList.size();
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) ContainerList.get(i);
            if (selectedOnly && !container.isSelected()) {
                continue;
            }
            ShapeContainer[] children = container.getGroupedSingleShapeContainers();
            for (int j = 0; j < children.length; j++) {
                workVector.add(children[j]);
            }
        }
        size = workVector.size();
        ShapeContainer[] containers = new ShapeContainer[size];

        for (int i = 0; i < size; i++) {
            containers[i] = (ShapeContainer) workVector.get(i);
            //this.setContainerIndex(containers[i], "getAllSigleShapeContainers()");
        }

        if (this.undoSetup) {
            this.backup(containers);
        }
        return containers;
    }

	public void renumberContainerList(){
		Vector vector=this.getAllShapeContainers();
		int size=vector.size();
		for(int i=0;i<size;i++){
			ShapeContainer container=(ShapeContainer)vector.get(i);
			String shapeId=container.getShapeId();
			String newShapeId = "";
			int id = shapeId.indexOf("(");
			newShapeId = shapeId.substring(0, id);
			newShapeId+= "(No-" + i+ ")";
			container.setShapeId(newShapeId);
		}
	}
	
    public ShapeContainer getEditableTextBox() {
        workVector.clear();
        int size = ContainerList.size();
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) ContainerList.get(i);
            ShapeContainer[] shapeContainers = container.getGroupedSingleShapeContainers();
            for (int j = 0; j < shapeContainers.length; j++) {
                if (shapeContainers[j].isEditableTextBox()) {
                    this.workVector.add(shapeContainers[j]);
                }
            }
        }
        if (workVector.size() == 0) {
            return null;
        }
        if (workVector.size() > 1) {
            System.err.println("*** Warning ContainerManager.getEditableTextBox "
                    + "Multiple ActivatedTextBoxes exist");
            for (int i = 1; i < workVector.size(); i++) {
                ShapeContainer container = (ShapeContainer) workVector.get(i);
                container.makeTextBoxEditable(false);
            }
        }
        ShapeContainer container = (ShapeContainer) workVector.get(0);
        //this.setContainerIndex(container, "getEditableTextBox()");
        if (this.undoSetup) {
            this.backup(container);
            this.backup(container.getTopParent());
        }
        return container;
    }

    public void makeAllTextBoxesUneditable() {
        int size = ContainerList.size();
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) ContainerList.get(i);
            TextBox[] textBoxes = container.getGroupedTextBoxes();
            for (int j = 0; j < textBoxes.length; j++) {
                textBoxes[j].getShapeContainer().makeTextBoxEditable(false);
            }
        }
    }

    public void deSelectAll() {
        int size = ContainerList.size();
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) ContainerList.get(i);
            container.setSelected(false);
        }
    }

    public void swapContainers(ShapeContainer container1, ShapeContainer container2) {
        int index1 = this.getContainerIndex(container1);
        int index2 = this.getContainerIndex(container2);
        if (index1 < index2) {
            this.deleteContainer(container2);
            this.addContainer(index1, container2);
        }
        if (index2 < index1) {
            this.deleteContainer(container1);
            this.addContainer(index2, container1);
        }
    }


    public ShapeContainer group(ShapeContainer[] containers) {
        if (debug > 0) System.out.println(" ContainerManager.group");
        if(containers.length<=1) return null;
       //---------------------//  
        this.undoSetupStart();
       //---------------------//  
        ShapeContainer groupContainer = new ShapeContainer();
        GroupElement child = new GroupElement();
        groupContainer.setElement(child);
        child.setShapeContainer(groupContainer);
        groupContainer.setNewShapeId(this, false);
        int indexMax = 0;
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; i++) {
            int index = this.getContainerIndex(containers[i]);
            if (index > indexMax) {
                indexMax = index;
            }
            child.addChildren(containers[i]);
            containers[i].setParent(groupContainer);
            containers[i].setSelected(false);
        }
        this.validShapeId(groupContainer);
        this.addContainer(indexMax, groupContainer);
        groupContainer.setSelected(true);
        for (int i = 0; i < size; i++) {
            this.deleteContainer(containers[i]);
        }
       //-------------------//  
        this.undoSetupEnd();
       //-------------------//  
        ObjectTable.getDrawPanel().repaint("ExecCommand.group");  
        return groupContainer;
    }

    public void unGroup(ShapeContainer[] containers) {
        int size=0;
        if(containers!=null) size=containers.length;
        Vector vector=new Vector();
        for(int i=0;i<size;i++){
            if(containers[i].getContainerType()==ShapeContainer.GROUP){
                boolean ungrouping=containers[i].getBooleanProperty("Enable_Ungrouping",
                        "ContainerManager.ungroup");
                if(!ungrouping) {
                    vector.add(containers[i]);
                    containers[i].setBlinking(true);
                }  
            }
        }
        
        int blinkingSize=vector.size();
        if(blinkingSize>0){
            BlinkingShape blinkingShape=ObjectTable.getBlinkingShape();
            blinkingShape.startBlinking();
            String message=" Warning: The specified group is not allowed to enable ungrouping."
                    + "\n You can reset it using the property tab of 'Shape Format' dialog";
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(),
                 message, "", JOptionPane.ERROR_MESSAGE);
            for(int i=0;i<blinkingSize;i++){
                ShapeContainer container=(ShapeContainer)vector.get(i);
                container.setBlinking(false);
            }
            blinkingShape.stopBlinking();
        }
        
       //----------------------//  
        this.undoSetupStart();
       //----------------------//  
        for(int i=0;i<size;i++){
            if(containers[i].getContainerType()==ShapeContainer.GROUP){
            //---- check targets[i] property ---//
                boolean ungrouping=containers[i].getBooleanProperty("Enable_Ungrouping",
                        "ExecCommand");
                if(!ungrouping) {
                    containers[i].setSelected(false);
                    continue;
                }
              //----------------------------------//
                ShapeContainer shapeContainer=(ShapeContainer)containers[i];
                this.unGroup(shapeContainer);      
            }
        }
       //---------------------//  
         this.undoSetupEnd();
       //---------------------//  
         ObjectTable.getDrawPanel().repaint("ExecCommand.Ungroup");
    }
    
    public void unGroup(ShapeContainer groupContainer) {
        //int size=0;
        if (groupContainer.getContainerType() == ShapeContainer.GROUP) {
            int index = this.getContainerIndex(groupContainer);
            GroupElement childrenList = (GroupElement) groupContainer.getElement();
            ShapeContainer[] children = childrenList.getChildren();
            for (int j = children.length - 1; j >= 0; j--) {
                this.addContainer(index, children[j]);
                children[j].setParent(null);
                children[j].setSelected(true);
            }
            this.deleteContainer(groupContainer);
        }
    }

    public void undoSetupStart() {
        if(this.undoSetup){
             System.err.println("*** Error ContainerManager.undoSetupStart: "
                     + "this.undoSetup is already set");
             return;
        }
        this.undoSetup = true;
        this.undoEdit = false;
        this.BackupContainerList.clear();
        int size = this.ContainerList.size();
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) this.ContainerList.get(i);
            container.resetChangeCode();
            ShapeContainer[] childContainers = container.getGroupedContainers();
            for (int j = 0; j < childContainers.length; j++) {
                childContainers[j].resetChangeCode();
            }
        }
    }
    

    public void undoSetupStart(ShapeContainer[] containers) {
        this.undoSetup = true;
        this.undoEdit = false;
        this.BackupContainerList.clear();
        int size = this.ContainerList.size();
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) this.ContainerList.get(i);
            container.resetChangeCode();
            ShapeContainer[] childContainers = container.getGroupedContainers();
            for (int j = 0; j < childContainers.length; j++) {
                childContainers[j].resetChangeCode();
            }
        }
        this.backup(containers);
    }

    private void backup(ShapeContainer container) {
        ShapeContainer backupContainer = this.getBackup(container.getShapeId());
        if (backupContainer != null) {
            return;
        }
        backupContainer = (ShapeContainer) container.clone();
        backupContainer.setShapeId(container.getShapeId());
        //System.out.println("container="+container.toString());
        //System.out.println("backupContainer="+backupContainer.toString());
        this.BackupContainerList.add(backupContainer);
    }

    private void backup(ShapeContainer[] containers) {
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; i++) {
            this.backup(containers[i]);
        }
    }

    private ShapeContainer getBackup(String shapeId) {
        ShapeContainer backupContainer = null;
        int size = this.BackupContainerList.size();
        if(size>1000){
            String str="*** Warning ContainerManager: BackupContainerList.size>1000";
            System.out.println(str);
            System.err.println(str);
        }
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) this.BackupContainerList.get(i);
            if (container.getSerialNumber() == this.getSerialNumber(shapeId)) {
                backupContainer = container;
                break;
            }
        }
        return backupContainer;
    }

    public void undoSetupOfAddOrDelete(int type, ShapeContainer container) {
        if (!this.undoSetup) {
            return;
        }
        UndoDrawManager undoManager = ObjectTable.getUndoDrawManager("Containermanager");
        if (type == UndoConstants.ADD) {
            UndoableDrawEdit.CreateContainer createContainer =
                    new UndoableDrawEdit.CreateContainer(container);
            undoManager.addEdit(createContainer);
            this.undoEdit = true;
        }
        if (type == UndoConstants.DELETE) {
            UndoableDrawEdit.DeleteContainer deleteContainer =
                    new UndoableDrawEdit.DeleteContainer(container);
            undoManager.addEdit(deleteContainer);
            this.undoEdit = true;
        }
        if (debug > 0) {
            System.out.println("ContainerManager.undoSetupOfAddOrDelete "
                    + "type=" + UndoConstants.undoStr[type]
                    + ", container=" + container.getShapeId());
        }
    }

    public void undoSetupEnd() {
        if (!this.undoSetup) {
            return;
        }
        UndoDrawManager undoManager = ObjectTable.getUndoDrawManager("Containermanager");
        //---------------------------------//
        if (debug >0) {
            this.printUndoSetup();
        }
        //---------------------------------//
        int size = this.ContainerList.size();
        for (int i = 0; i < size; i++) {
            boolean undoSet = false;
            ShapeContainer container = (ShapeContainer) this.ContainerList.get(i);
            ShapeContainer[] childContainers = container.getGroupedContainers();
            for (int j = 0; j < childContainers.length; j++) {
                ShapeContainer child=childContainers[j];
                if (child.getChangeCode() == UndoConstants.CONTAINER
                        || child.getChangeCode() == UndoConstants.SIZE_POSITION
                        || child.getChangeCode() == UndoConstants.SHAPE) {
                    undoSet = this.undoSetupEndOfContainer(child);
                }
                if (child.getChangeCode() == UndoConstants.TEXTBOX) {
                    undoSet = this.undoSetupEndOfTextBox(child);
                }
                if (child.getChangeCode() == UndoConstants.PAINTSTYLE) {
                    undoSet = this.undoSetupEndOfPaintStyle(child);
                }
                if (undoSet) {
                    this.undoEdit = true;
                }
            }
        }
        if (this.undoEdit) {
            UndoableDrawEdit.Delimiter delimiter = new UndoableDrawEdit.Delimiter();
            undoManager.addEdit(delimiter);
            if (debug > 0) {
                System.out.println("ContainerManager.undoSetupEnd, delimiter inserted");
            }
        }
        this.undoSetup = false;
        this.undoEdit = false;
        this.BackupContainerList.clear();
    }

    private void printUndoSetup() {
        int size = this.ContainerList.size();
        System.out.println("** print undo setup");
        for (int i = 0; i < size; i++) {
            ShapeContainer container = (ShapeContainer) this.ContainerList.get(i);
            ShapeContainer[] childContainers = container.getGroupedContainers();
            for (int j = 0; j < childContainers.length; j++) {
                ShapeContainer child=childContainers[j];
                int code = child.getChangeCode();
                if (code == UndoConstants.CONTAINER
                        || code == UndoConstants.SIZE_POSITION
                        || code == UndoConstants.SHAPE
                        || code == UndoConstants.TEXTBOX
                        || code == UndoConstants.PAINTSTYLE) {
                    System.out.println(" -- changed code="
                        + UndoConstants.undoStr[code] + ",  " + child.toShortString());
                }
            }
        }
    }

    private boolean undoSetupEndOfContainer(ShapeContainer container) {
        UndoDrawManager undoManager = ObjectTable.getUndoDrawManager("Containermanager");
        boolean undoSet = false;
        if (container.getChangeCode() < 0) {
            return undoSet;
        }
        ShapeContainer backupContainer = this.getBackup(container.getShapeId());
        if (backupContainer == null) {
            if (debug > 0) {
                System.out.println("ContainerManager.undoSetupEndOfContainer no backupContainer"
                        + "\n container=" + container.toShortString());
            }
            return undoSet;
        }

        UndoableDrawEdit.ChangeContainer changeContainer =
                new UndoableDrawEdit.ChangeContainer(backupContainer, container);
        undoManager.addEdit(changeContainer);
        if (debug > 0) {
            System.out.println("ContainerManager.undoSetupEndOfContainer"
                    + ", container=" + container.getShapeId()
                    + ", changedCode=" + UndoConstants.undoStr[container.getChangeCode()]
                    + ", backupContainer=" + backupContainer.toString());
        }
        container.resetChangeCode();
        undoSet = true;
        return undoSet;
    }

    private boolean undoSetupEndOfTextBox(ShapeContainer container) {
        UndoDrawManager undoManager = ObjectTable.getUndoDrawManager("Containermanager");
        boolean undoSet = false;

        ShapeContainer backupContainer = this.getBackup(container.getShapeId());
        if (backupContainer == null) {
            System.out.println("ContainerManager.undoSetupEndOfTextBox no backupContainer"
                    + ", container=" + container.toShortString());
            return undoSet;
        }
        String shapeId = container.getShapeId();
        TextBox[] textBoxes = container.getGroupedTextBoxes();
        ShapeContainer parentContainer = null;
        for (int i = 0; i < textBoxes.length; i++) {
            if (textBoxes[i].getShapeContainer().getChangeCode() < 0) {
                continue;
            }
            parentContainer = textBoxes[i].getShapeContainer();
            String parentShapeId = parentContainer.getShapeId();
            int parentNum = parentContainer.getSerialNumber();
            TextBox backupTextBox = backupContainer.getGroupedTextBox(parentNum);

            UndoableDrawEdit.ChangeTextBox changeTextBox =
                    new UndoableDrawEdit.ChangeTextBox(parentShapeId, backupTextBox, textBoxes[i]);
            undoManager.addEdit(changeTextBox);
            textBoxes[i].getShapeContainer().resetChangeCode();
            ;
            undoSet = true;
            if (debug > 0) {
                System.out.println("ContainerManager undoSetupEndOfTextBox type="
                        + ", targetContainer=" + parentContainer.getShapeId());
            }
        }

        return undoSet;
    }

    private boolean undoSetupEndOfPaintStyle(ShapeContainer container) {
        UndoDrawManager undoManager = ObjectTable.getUndoDrawManager("Containermanager");
        int size = this.ContainerList.size();
        boolean undoSet = false;
        ShapeContainer backupContainer = this.getBackup(container.getShapeId());
        if (backupContainer == null) {
            System.out.println("ContainerManager.undoSetupEndOfPaintStyle no backupContainer"
                    + ", container=" + container.toShortString());
            return undoSet;
        }
        String shapeId = container.getShapeId();
        PaintStyle[] paintStyles = container.getGroupedPaintStyles();
        ShapeContainer parentContainer = null;
        for (int i = 0; i < paintStyles.length; i++) {
            if (paintStyles[i].getShapeContainer().getChangeCode() < 0) {
                continue;
            }
            parentContainer = paintStyles[i].getShapeContainer();
            String parentShapeId = parentContainer.getShapeId();
            int parentNum = parentContainer.getSerialNumber();
            PaintStyle backupPaintStyle = backupContainer.getGroupedPaintStyle(parentNum);
            UndoableDrawEdit.ChangePaintStyle changePaintStyle =
                    new UndoableDrawEdit.ChangePaintStyle(parentShapeId, backupPaintStyle, paintStyles[i]);
            undoManager.addEdit(changePaintStyle);
            paintStyles[i].getShapeContainer().resetChangeCode();
            ;
            undoSet = true;
            if (debug > 0) {
                System.out.println("ContainerManager undoSetupEndOfPaintStyle type="
                        + ", targetContainer=" + parentContainer.getShapeId());
            }
        }
        return undoSet;
    }
	
    public void printContainers(String message) {
        System.out.println("\n ContainerManager.printContainers  title:" + message);
        ShapeContainer[] containers = getContainers();
        for (int i = 0; i < containers.length; i++) {
            System.out.println(" - Container[" + i + "] ; " + containers[i].toShortString()+"\n");
        }//for(int j=0)
    }
	
	void printShapeIds(String title, ShapeContainer[] containers){
		int size=containers.length;
		String str =title+"\n";
		for (int i = 0; i < size; i++) {
			if (i > 0) str += ", ";
			else str += "  ";
			str += "container[" + i + "]=" + containers[i].getShapeId();
		}
		System.out.println(str);
	}
	
    public void printAllShapeContainers(String message) {
        System.out.println("\n ContainerManager.printAllShapeContainers  title:" + message);
        this.getAllShapeContainers();
        for (int i = 0; i < this.workVector.size(); i++) {
            ShapeContainer container=(ShapeContainer)this.workVector.get(i);
            System.out.println(" - Container[" + i + "] ; " + container.toShortString()+"\n");
        }//for(int j=0)
    }

    public String toString() {
        String str = "";
        str += "ContainerManager ContainerList";
        ShapeContainer[] containers = getContainers();
        if (containers.length == 0) {
            str += "=null";
        }
        for (int i = 0; i < containers.length; i++) {
            str += "\n  container[" + i + "]=" + containers[i].getShapeId()
                    + ", containerIndex :" + containers[i].getContainerIndex();
        }//for(int j=0)
        return str;
    }
}//end of DrawPanel

