/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package util;

import java.awt.GraphicsEnvironment.*;
import java.io.*;
import java.io.File.*;

public class FileInformation {

   ConfigFile configFile = new ConfigFile();
   int debug = 0;

   public String getDirectory() {
      File file = new File("");
      String currentPath = file.getAbsolutePath();
      String filePath = currentPath + "/Application.config";
      file = new File(filePath);
      if (!file.isFile()) {
         try {
            if(debug>0) System.out.println("* FileInformation getDirectory() create Application.config file");
            file.createNewFile();
            writeConfigFile();
         } catch (Exception e) {
            System.out.println("*** Error: FileChooserDirectory getDirectory, "
                    + "File.createNewFile");
            return "";
         }
      }
      //-----------------------------------------------//  
      this.configFile.setFileName(filePath);
      //-----------------------------------------------// 
      if (debug > 0) {
         System.out.println(" - FileDirectoryInformation.getDirectory "
                 + "configFile=" + configFile);
      }
      try {
         this.configFile.load();
      } catch (IOException e) {
         System.out.println("** Application.config not found e=" + e);
         return "";
      }
      String fileChooserDirectory = "";
      fileChooserDirectory = this.configFile.getValue("FileChooser.Directory");
      if (fileChooserDirectory == null || fileChooserDirectory.equals("")) {
         System.err.println("*** Warning: FileDirectoryInformation.getDirectory=null");
      }
      if (debug > 0) {
         System.out.println(" - FileDirectoryInformation.getDirectory "
                 + "fileChooserDirectory=" + fileChooserDirectory);
      }
      return fileChooserDirectory;
   }//End of getDirectory

   public void writeConfigFile() {
      File file = new File("");
      String currentPath = file.getAbsolutePath();
      String filePath = currentPath + "/Application.config";

      if (debug > 0) System.out.println("* FileInformation writeConfigFile filePath=" + filePath);
      this.configFile.setFileName(filePath);
      try {
         this.configFile.load();
      } catch (IOException ioe) {
         System.out.println("*** Error: Application.config not found\n  ioe=" + ioe);
      }
      String str = "C:\\Users\\jyou\\Documents\\";
      this.configFile.putValue("FileChooser.Directory", str);
      try {
         this.configFile.save();
      } catch (IOException ioe) {
         System.out.println("*** Error: FileChooser.Directory ConfFile save error ioe=" + ioe);
      }
   }//writeConfigFile

   public void setFileDirectory(String fileChooserDirectory) {
      File file = new File("");
      String currentPath = file.getAbsolutePath();
      String filePath = currentPath + "/Application.config";
      this.configFile.setFileName(filePath);
      if (debug > 0) {
         System.out.println(" - FileDirectoryInformation.setDirectory "
                 + "configFile=" + configFile);
      }
      try {
         this.configFile.load();
      } catch (IOException ioe) {
         System.out.println("*** Error: Application.config not found");
      }
      this.configFile.putValue("FileChooser.Directory", fileChooserDirectory);
      try {
         this.configFile.save();
      } catch (IOException ioe) {
         System.out.println("*** Error: FileChooser.Directory ConfFile save error ioe=" + ioe);
      }
   }//End of setDirectory

   public String convertToDirectoryName(String filePath) {
      int index = filePath.lastIndexOf("\\");
      String fileDirectory = "";
      if (index > 0) {
         //int length=filePath.length();
         fileDirectory = filePath.substring(0, index + 1);
         if (debug > 0) {
            System.out.println("** fileDirectory=" + fileDirectory);
         }
      }
      if (debug > 0) {
         System.out.println(" - FileDirectoryInformation.getDirectoryName fileDirectory=" + fileDirectory);
      }
      return fileDirectory;
   } //End of getDirectoryName

   public String getSimpleFileName(String filePath) {
      int index = filePath.lastIndexOf("\\");
      String fileName = "";
      if (index > 0) {
         int length = filePath.length();
         fileName = filePath.substring(index + 1, length);
         if (debug > 0) {
            System.out.println("** fileDirectory=" + fileName);
         }
      }
      if (debug > 0) {
         System.out.println(" - FileDirectoryInformation.getDirectoryName fileDirectory=" + fileName);
      }
      return fileName;
   } //End of getDirectoryName

}
