/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package DrawTop;
import util.*;

/**
 *
 * @author jyounishi
 */
public class Command{
    int commandId=-1;
    int callFrom=0;
    Object[] params;
	static int debug=0;
    
//Command Id
    public final static int NEW=0;
    public final static int OPEN=1;
    public final static int SAVE=2;
    public final static int SAVEAS=3;
    public final static int PAGE=4;
    public final static int NEXT_PAGE=5;
    public final static int PREVIOUS_PAGE=6;
    public final static int LAST_PAGE=7;
    public final static int TOP_PAGE=8;
    public final static int INSERT_NEW_PAGE=9;
    public final static int DELETE_PAGE=10;
    public final static int PAGE_SETUP=12;
    public final static int PAGE_LAYOUT=13;
    public final static int PRINT=14;
    public final static int EXIT=17;
    
    public final static int EDIT=20;
    public final static int CUT=21;
    public final static int COPY=22;
    public final static int PASTE=23;
    public final static int DEL=24;
    public final static int DELETE=25;
    public final static int SELECT_ALL=26;
    public final static int UNDO=30;
    public final static int REDO=31;
    public final static int CLICKEDPOINT=32;
    public final static int SELECTION=33;
    
    public final static int SHAPE=40;
    public final static int TEXTBOX=41;
    public final static int RECTANGLE=43;
    public final static int ROUND_RECTANGLE=44;
    public final static int ELLIPSE=45;
    public final static int IMAGE=46;
    public final static int COMPONENT_SHAPE=39;
    
    public final static int LINE=51;
    public final static int ARROW=52;
    public final static int DOUBLE_ARROW=53;
    public final static int POLYLINE=54;
    public final static int CUBIC_CURVE=55;
    public final static int GENERAL_CURVE=56;
    public final static int COMBINED_CURVE=57;
    public final static int AUTO_SHAPE_FIRST=41;
    public final static int AUTO_SHAPE_LAST=57;

    public final static int AUX=60;
    public final static int CENTER_LINE=61;
    public final static int LINE_BISECTOR=62;
    public final static int ANGLE_BISECTOR=63;

    public final static int LIB=80;
    
    public final static int MOVE=81;
    public final static int RESIZE=82;
    public final static int MOVE_ENDPT=83;
    
    public final static int UTIL=85;
    public final static int ADD_TEXTBOX=86;
    public final static int DELETE_TEXTBOX=87;
    public final static int TRANSLATE=88;
    public final static int ROTATE=89;
    public final static int FLIP=90;
    public final static int EXTEND_CURVE=91;
    public final static int CUT_SHAPE=92;
    public final static int CONNECT_CURVES=93;
    public final static int COMBINE=94;
    public final static int BREAK=95;
    
    public final static int CHANGE_SHAPE=100;
    public final static int MODIFY_SHAPE=101;
    public final static int MOVE_POINT=102;
    public final static int MOVE_EDGE=104;
    public final static int ADD_POINT=105;
    public final static int DELETE_POINT=106;
    public final static int SMOOTH=107;
    public final static int CUSP=108;
    public final static int DISCONNECT=109;
    
    public final static int SETTING=110;
    public final static int AUTO_ALIGN=111;
    public final static int ENABLE_CONNECTOR=112;
    public final static int FREE_DIRECTION=113;
    public final static int KEEP_XY_DIRECTION=114;
    public final static int KEEP_DIRECTION=117;
    public final static int TO_NEAREST_PT=116;
    public final static int HIGHLIGHTING_FOR_SELECTION=118;
    public final static int DRAW_NODE_POINTS=119;
    
    public final static int SHAPE_FORMAT=120;
    public final static int DRAW_PANEL_INFORMATION=121;
    //public final static int GROUP_POPUP_MENU=92;
    
    public final static int FONT=130;
    public final static int FONT_FAMILY=131;
    public final static int FONT_SIZE=132;
    public final static int BOLD=133;
    public final static int ITALIC=134;
    public final static int UNDERLINE=135;
    public final static int SUBSCRIPT=136;
    public final static int SUPERSCRIPT=137;
    public final static int FONT_COLOR=138;
    
    public final static int TEXTBOX_LAYOUT=140;
    public final static int TEXT_ALIGN=142;
    public final static int TEXT_ALIGN_LEFT=143;
    public final static int TEXT_ALIGN_CENTER=144;
    public final static int TEXT_ALIGN_RIGHT=145;
    //public final static int TEXT_LINESPACE=126;

    public final static int FILL_COLOR=150;
    public final static int LINE_COLOR=151;
    public final static int LINE_WIDTH=152;
    public final static int LINE_STROKE=153;
    public final static int ARROW_STYLE=154;

    public final static int Z_ORDER=160;
    public final static int MOVE_TO_FRONT=161;
    public final static int MOVE_TO_BACK=162;
    public final static int MOVE_FORWARD=163;
    public final static int MOVE_BACKWARD=164;
    
    public final static int ALIGN=170;
    public final static int ALIGN_LEFT=171;
    public final static int ALIGN_CENTER=172;
    public final static int ALIGN_RIGHT=173;
    public final static int ALIGN_TOP=174;
    public final static int ALIGN_MIDDLE=175;
    public final static int ALIGN_BOTTOM=176;
    
    public final static int GROUP=180;
    public final static int UNGROUP=181;
    public final static int REGROUP=182;

    public final static int ZOOM=185;
    public final static int ZOOM_TO=186;

    public final static int DEBUG=190;
    public final static int TEST=191;
    public final static int GEOMTEST=192;
    public final static int DRAW_BOUNDING_BOX=193;
    public final static int DRAW_CHARACTERISTIC_PT=194;
    public final static int DRAW_TEXTLAYOUT_BOUND=195;
    public final static int UNSELECTABLE_AREAS=196;
    public final static int CONNECTION_TEST=197;

    
    public final static int DRAWPANEL_POPUP_MENU=200;
    public final static int SHAPE_POPUP_MENU=201;
    public final static int GROUP_POPUP_MENU=202;
    public final static int TEXTBOX_POPUP_MENU=203;
    public final static int ABORT_COMMAND=209;

    public final static int ORIGINAL_TYPE =250;
    //public final static int MOVABLE = 251;
    //public final static int RESIZABLE = 252;
    public final static int ENABLE_RESIZING = 253;
    //public final static int UNRESIZABLE = 254;
    public final static int KEEP_ASPECT_RATIO= 255;
    public final static int KEEP_LINE_DIRECTION = 256;
    public final static int KEEP_CONNECTOR_CONNECTIONS = 257;
    //public final static int UNABLE_TO_DRAG_CONNECTORS = 258;
    public final static int ENABLE_UNGROUPING = 259;
    //public final static int UNABLE_UNGROUPING = 260;
    
    static String[] commandString=new String[300];
    
// mode 
    public static final int NORMAL_MODE=0;
    public static final int CREATING_MODE=1;
    public static final int MOVING_MODE=2;
    public static final int RESIZING_MODE=3;
    public static final int MOVING_ENDPT_MODE=4;
    public static final int MODIFYING_SHAPE_MODE=5;
    final static String[] modeString=
        {"NORMAL_MODE", "CREATING_MODE", "MOVING_MODE", "RESIZE_MODE", "MOVE_ENDPT_MODE", "MODIFY_SHAPE_MODE"};
    
// set call from
    public static final int callFromMenu=1;
    public static final int callFromMousePositionLS=2;
    public static final int callFromSelectionLS=3;
    public static final int callFromMouseListener=4;
    public static final int callFromDialog=5;
    final static String[] callFromString=
        {"        " ,"Menu", "MousePositionLS", "SelectionLS", "MouseListener","Dialog"};
     
    public Command(){
        this.setCommandStrings();
    }
    
    public Command(int commandId, int callFrom, Object[] params){
        this.commandId=commandId;
        this.callFrom=callFrom;
        this.params=params;
    }
   
    public int getCommandId(){
       return this.commandId;
    }
   
    public int getCallFrom(){
       return this.callFrom;
    }
   
    public Object[] getParams(){
        return this.params;
   }
   
    public String toString(){
        String str="name=";
        str+=getCommandString(this.commandId)+", commandId="+this.commandId+
                ", callFrom="+getCallFromString(this.callFrom);
        Object[] args=this.getParams();
        if(args==null||args.length==0) str+=", args=null";
        else {
            for(int i=0;i<args.length;i++) str+="\n  args["+i+ "]="
					+"(type: "+args[i].getClass().getSimpleName()+"), details="+args[i];

        }
        return str;
    }
/*
    public String toString() {
		String str = "name=";
		str += getCommandString(this.commandId) + ", commandId=" + this.commandId
				+ ", callFrom=" + getCallFromString(this.callFrom);
		Object[] args = getParams();
		if (args == null || args.length == 0) {
			str += ", args=null";
		} else {
			for (int i = 0; i < args.length; i++) {
				str += ", args=" + args[i];
			}
		}
		return str;
	}
*/
    private void setCommandStrings(){
        for(int i=0;i<commandString.length;i++) {
            commandString[i]="";
        }
        //String guidanceText="";
        setCommandString(NEW, "NEW");
        setCommandString(OPEN, "OPEN");
        setCommandString(SAVE, "SAVE");
        setCommandString(SAVEAS, "SAVEAS");
        setCommandString(PAGE, "PAGE");
        setCommandString(NEXT_PAGE, "NEXT_PAGE");
        setCommandString(PREVIOUS_PAGE, "PREVIOUS_PAGE");
        setCommandString(LAST_PAGE, "LAST_PAGE");
        setCommandString(TOP_PAGE, "TOP_PAGE");
        setCommandString(INSERT_NEW_PAGE, "INSERT_NEW_PAGE");
        setCommandString(DELETE_PAGE, "DELETE_PAGE");
        setCommandString(PAGE_SETUP, "PAGE_SETUP");
        setCommandString(PAGE_LAYOUT, "PAGE_LAYOUT");
        setCommandString(PRINT, "PRINT");
        setCommandString(EXIT, "EXIT");

        setCommandString(EDIT, "EDIT");
        setCommandString(CUT, "CUT");
        setCommandString(COPY, "COPY");
        setCommandString(PASTE, "PASTE");
        setCommandString(DEL, "DEL");
        setCommandString(DELETE, "DELETE");
        setCommandString(SELECT_ALL, "SELECT_ALL");
        setCommandString(UNDO, "UNDO");
        setCommandString(REDO, "REDO");

        setCommandString(CLICKEDPOINT, "CLICKEDPOINT");
        setCommandString(SELECTION, "SELECTION");
        
        setCommandString(SHAPE, "SHAPE");
        setCommandString(TEXTBOX, "TEXTBOX");
        setCommandString(RECTANGLE, "RECTANGLE");
        setCommandString(ROUND_RECTANGLE, "ROUND_RECTANGLE");
        setCommandString(ELLIPSE, "ELLIPSE");
        setCommandString(IMAGE, "IMAGE");
        setCommandString(COMPONENT_SHAPE, "COMPONENT_SHAPE");
        setCommandString(LINE, "LINE");
        setCommandString(ARROW, "ARROW");
        setCommandString(DOUBLE_ARROW, "DOUBLE_ARROW");
        setCommandString(POLYLINE, "POLYLINE");
        setCommandString(CUBIC_CURVE, "CUBIC_CURVE");
        setCommandString(GENERAL_CURVE, "GENERAL_CURVE");
        setCommandString(COMBINED_CURVE, "COMBINED_CURVE");
        setCommandString(AUX, "AUX");
        setCommandString(CENTER_LINE, "CENTER_LINE");
        setCommandString(LINE_BISECTOR, "LINE_BISECTOR");
        setCommandString(ANGLE_BISECTOR, "ANGLE_BISECTOR");
        
        
        setCommandString(LIB, "LIB");
        
        setCommandString(MOVE, "MOVE");
        setCommandString(RESIZE, "RESIZE");
        setCommandString(MOVE_ENDPT, "MOVE_ENDPT");
        
        setCommandString(UTIL, "UTIL");
        setCommandString(ADD_TEXTBOX, "ADD_TEXTBOX");
        setCommandString(DELETE_TEXTBOX, "DELETE_TEXTBOX");
        setCommandString(TRANSLATE, "TRANSLATE");
        setCommandString(ROTATE, "ROTATE");
        setCommandString(FLIP, "FLIP");
        setCommandString(EXTEND_CURVE, "EXTEND_CURVE");
        setCommandString(CUT_SHAPE, "CUT_SHAPE");
        setCommandString(CONNECT_CURVES, "CONNECT_CURVES");
        setCommandString(CHANGE_SHAPE, "CHANGE_SHAPE");
        setCommandString(MODIFY_SHAPE, "MODIFY_SHAPE");
        setCommandString(COMBINE, "COMBINE");
        setCommandString(BREAK, "BREAK");
        
        setCommandString(MOVE_POINT, "MOVE_POINT");
        setCommandString(MOVE_EDGE, "MOVE_EDGE");
        setCommandString(ADD_POINT, "ADD_POINT");
        setCommandString(DELETE_POINT, "DELETE_POINT");
        setCommandString(SMOOTH, "SMOOTH");
        setCommandString(CUSP, "CUSP");
        setCommandString(DISCONNECT, "DISCONNECT");
        //setCommandString(EXIT_UTIL, "EXIT_UTIL");

        setCommandString(SETTING, "SETTING");
        setCommandString(AUTO_ALIGN, "AUTO_ALIGN");
        setCommandString(ENABLE_CONNECTOR, "ENABLE_CONNECTOR");
        //setCommandString(FREE_DIRECTION, "FREE_DIRECTION");
        setCommandString(FREE_DIRECTION, "FREE_DIRECTION");
        //setCommandString(KEEP_XY_DIRECTION, "KEEP_XY_DIRECTION");
        setCommandString(KEEP_XY_DIRECTION, "KEEP_XY_DIRECTION");
        setCommandString(KEEP_DIRECTION, "KEEP_DIRECTION");
        setCommandString(TO_NEAREST_PT, "TO_NEAREST_PT");
        setCommandString(HIGHLIGHTING_FOR_SELECTION, "HIGHLIGHTING_FOR_SELECTION");
        setCommandString(DRAW_NODE_POINTS, "DRAW_NODE_POINTS");
        
        setCommandString(SHAPE_FORMAT, "SHAPE_FORMAT");
        setCommandString(DRAW_PANEL_INFORMATION, "DRAW_PANEL_INFORMATION");
        //setCommandString(GROUP_POPUP_MENU, "GROUP_POPUP_MENU");

        setCommandString(FONT, "FONT");
        setCommandString(FONT_FAMILY, "FONT_FAMILY");
        setCommandString(FONT_SIZE, "FONT_SIZE");
        setCommandString(BOLD, "BOLD");
        setCommandString(ITALIC, "ITALIC");
        setCommandString(SUBSCRIPT, "SUBSCRIPT");
        setCommandString(SUPERSCRIPT, "SUPERSCRIPT");
        setCommandString(UNDERLINE, "UNDERLINE");
        setCommandString(FONT_COLOR, "FONT_COLOR");

        setCommandString(TEXTBOX_LAYOUT, "TEXTBOX_LAYOUT");
        //setCommandString(TEXTBOX_INSETS, "TEXTBOX_INSETS");
        setCommandString(TEXT_ALIGN, "TEXT_ALIGN");
        setCommandString(TEXT_ALIGN_LEFT, "TEXT_ALIGN_LEFT");
        setCommandString(TEXT_ALIGN_CENTER, "TEXT_ALIGN_CENTER");
        setCommandString(TEXT_ALIGN_RIGHT, "TEXT_ALIGN_RIGHT");
        //setCommandString(TEXT_LINESPACE, "TEXT_LINESPACE");
        
        setCommandString(FILL_COLOR, "FILL_COLOR");
        setCommandString(LINE_COLOR, "LINE_COLOR");
        setCommandString(LINE_WIDTH, "LINE_WIDTH");
        setCommandString(LINE_STROKE, "LINE_STROKE");
        setCommandString(ARROW_STYLE, "ARROW_STYLE");

        setCommandString(ALIGN, "ALIGN");
        setCommandString(ALIGN_LEFT, "ALIGN_LEFT");
        setCommandString(ALIGN_CENTER, "ALIGN_CENTER");
        setCommandString(ALIGN_RIGHT, "ALIGN_RIGHT");
        setCommandString(ALIGN_TOP, "ALIGN_TOP");
        setCommandString(ALIGN_MIDDLE, "ALIGN_MIDDLE");
        setCommandString(ALIGN_BOTTOM, "ALIGN_BOTTOM");
        
        setCommandString(Z_ORDER, "Z_ORDER");
        setCommandString(MOVE_TO_FRONT, "MOVE_TO_FRONT");
        setCommandString(MOVE_TO_BACK, "MOVE_TO_BACK");
        setCommandString(MOVE_FORWARD, "MOVE_FORWARD");
        setCommandString(MOVE_BACKWARD, "MOVE_BACKWARD");
        
        //setCommandString(GROUPING, "GROUPING");
        setCommandString(GROUP, "GROUP");
        setCommandString(UNGROUP, "UNGROUP");
        //setCommandString(REGROUP, "REGROUP");
        
        setCommandString(ZOOM, "ZOOM");
        setCommandString(ZOOM_TO, "ZOOM_TO");
        
        setCommandString(TEST, "TEST");
        //setCommandString(UNSELECTABLE_AREA, "UNSELECTABLE_AREA");
        setCommandString(GEOMTEST, "GEOMTEST");
        setCommandString(DRAW_BOUNDING_BOX, "DRAW_BOUNDING_BOX");
        setCommandString(DRAW_CHARACTERISTIC_PT, "DRAW_CHARACTERISTIC_PT");
        setCommandString(DRAW_TEXTLAYOUT_BOUND, "DRAW_TEXTLAYOUT_BOUND");
        setCommandString(UNSELECTABLE_AREAS, "UNSELECTABLE_AREAS");
        setCommandString(CONNECTION_TEST, "CONNECTION_TEST");
        
        
        setCommandString(DEBUG, "DEBUG");
        //setCommandString(TRACE, "TRACE");

        setCommandString(DRAWPANEL_POPUP_MENU, "DRAWPANEL_POPUP_MENU");
        setCommandString(SHAPE_POPUP_MENU, "SHAPE_POPUP_MENU");
        setCommandString(GROUP_POPUP_MENU, "GROUP_POPUP_MENU");
        setCommandString(TEXTBOX_POPUP_MENU, "TEXTBOX_POPUP_MENU");
        setCommandString(ABORT_COMMAND, "ABORT_COMMAND");

      //Supplemental
        setCommandString(ORIGINAL_TYPE, "ORIGINAL_TYPE");
        //setCommandString(RESIZABLE, "RESIZABLE");
        setCommandString(ENABLE_RESIZING, "ENABLE_RESIZING");
        setCommandString(KEEP_ASPECT_RATIO, "KEEP_ASPECT_RATIO");
        setCommandString(KEEP_LINE_DIRECTION, "KEEP_LINE_DIRECTION");
        setCommandString(KEEP_CONNECTOR_CONNECTIONS, "KEEP_CONNECTOR_CONNECTIONS");
        //setCommandString(UNABLE_TO_DRAG_CONNECTORS, "UNABLE_TO_DRAG_CONNECTORS");
        setCommandString(ENABLE_UNGROUPING, "ENABLE_UNGROUPING");
        //setCommandString(UNABLE_UNGROUPING, "UNABLE_UNGROUPING");

    }
    
    private void setCommandString(int commandId, String command){
        if(!commandString[commandId].equals(""))
            System.err.println("*** Warning: Command.setCommandString, CommandId duplicated" +
                    ", commandId="+commandId+", command="+command);
        commandString[commandId]=command;
    }

    public static String getCommandString(int commandId){
        String str="";
        if(commandId<0||commandId>=commandString.length){
           System.err.println("*** Error Command.getCommandString: illeagal commandId "+commandId);
           return str;
        }
        str=commandString[commandId];
        return str;
    }
    
    public static String getCommandString(String command){
        String str="";
        int size=commandString.length;
        for(int i=0;i<size;i++){
            if(compareStrings(command, commandString[i])){
                str=commandString[i];
                break;
            }
        }
        return str;
    }
    
    public static String getCommandLowerString(int commandId){
        String str="";
       if(commandId<0||commandId>=commandString.length){
           System.err.println("*** Error Command.getCommandLowercaseString: illeagal commandId "+commandId);
           return str;
       }
        str=commandString[commandId];
        if(!str.equals("")) {
            str=str.toLowerCase();
            str=str.replace("_", " ");
        }
        return str;
    }
    
    public static String getCallFromString(int callFrom){
        String str="";
        if(callFrom<=callFromString.length) str=callFromString[callFrom];
        return str;
    }

    public static String getModeString(int modeId){
        String str="";
        //if(modeId<0||modeId>MODIFY_SHAPE_MODE) return str;
        int len=Command.modeString.length;
        if(modeId<0||modeId>len-1) return str;
        str=Command.modeString[modeId];
        return str;
    }
    
   public static int getCommandId(String command){
       int id=-1;
       if(command==null||command.equals("")){
           System.err.println("*** Error in Command.getCommandId: argument command=null");
           return id;
       }
       for(int i=0;i<commandString.length;i++) {
           if(commandString[i].equals("")) continue;
           //if(commandString[i]==null&&commandString[i].equals("")) continue;
           if(!command.substring(0,1).equalsIgnoreCase(commandString[i].substring(0,1))) continue;
           if(Command.compareStrings(command, commandString[i])){
               id=i; break;
           }
       }
	   if(debug>0) System.out.println("** Command.getCommandId command="+command+", id="+id);
       return id;
   }
//----------------------//
//  compare two strings //
//----------------------//
    public static boolean compareStrings(String str1, String str2){
        boolean equal=false;
        //if(str1==null||str2==null) return false;
        if(str1.equals("")||str2.equals("")) return false;
        String compressedStr1=str1.replace(" ", "");
        compressedStr1=compressedStr1.replace("_", "");
        compressedStr1=compressedStr1.replace(".", "");
        String compressedStr2=str2.replace(" ", "");
        compressedStr2=compressedStr2.replace("_", "");
        compressedStr2=compressedStr2.replace(".", "");
        if(compressedStr1.compareToIgnoreCase(compressedStr2)==0) equal=true;
         return equal;
    }
    
}  