package DrawTop;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import shape.*;
import shapeUtil.*;
import menu.*;
import textBox.*;
import util.*;

public class ExecCommand {
    public ExecCommandUtil execUtil;
    private int currentCommandId=-1;
    private int previousCommandId=-1;
    public CreateShapeLS activeCreateShapeLS=null;
    Point2D clickedPoint=null;
    public static int debug=0;
    int idNumber=0;
    
    public ExecCommand(){
        ObjectTable.execCommand=this;
        this.execUtil=new ExecCommandUtil();
    }
    
    public void exec(Command command){
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
        SelectionLS  selectionLS=ObjectTable.getSelectionLS("");
        ContainerManager containerManager=ObjectTable.getContainerManager("");
        PageManager pageManager=ObjectTable.getPageManager("ExecCommand");
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        FileIo fileIO=ObjectTable.getFileIo("");
        Edit edit=ObjectTable.getEdit("");
      // clear temporary shapes  
        DrawShapeUtil.clearTempShape("ConnectedMessage");
        DrawShapeUtil.clearTempShape("ConnectionMark");
        DrawShapeUtil.clearTempShape("OnlinePT");
        DrawShapeUtil.clearTempShape("ConnectedPT");
        DrawShapeUtil.clearTempShape("Auto_align");
        
        int commandId=command.getCommandId();
        this.currentCommandId=commandId;
        if(commandId<0){
            System.err.println("*** Error ExecCommand.exec: specified command not found;"+command);
            return;
        }
        int callFrom=command.getCallFrom();
        Object[] params=command.getParams();
        if(debug>0) System.out.println("- ExecCommand.exec "+command.toString());
        
        if(this.activeCreateShapeLS!=null){
            if(callFrom!=Command.callFromMouseListener) {
                this.activeCreateShapeLS.abort();
                this.activeCreateShapeLS=null;
            }
        }

        switch(commandId){
            case Command.NEW: {fileIO.fileNew(); break;}
            case Command.OPEN: {fileIO.fileOpen(); break;}
            case Command.SAVE: {fileIO.fileSave(); break;}
            case Command.SAVEAS: {fileIO.fileSaveAs(); break;}
            case Command.PAGE: {
                String menuItem=(String)params[0];
                if(Command.getCommandId(menuItem)==Command.NEXT_PAGE) 
                        pageManager.showNextPage();
                if(Command.getCommandId(menuItem)==Command.PREVIOUS_PAGE) 
                        pageManager.showPreviousPage();
                if(Command.getCommandId(menuItem)==Command.LAST_PAGE) 
                        pageManager.showLastPage();
                if(Command.getCommandId(menuItem)==Command.TOP_PAGE) 
                        pageManager.showTopPage();
                if(Command.getCommandId(menuItem)==Command.INSERT_NEW_PAGE) 
                        pageManager.insertNewPage();
                if(Command.getCommandId(menuItem)==Command.DELETE_PAGE) 
                        pageManager.deletePage();
                if(Command.getCommandId(menuItem)==Command.PAGE_SETUP) {
                    DialogOfPageSetup dialog=new DialogOfPageSetup();
                    dialog.showDialog();
                }
                drawPanel.repaint("ExecCommand.Page");
                break;
            }
            case Command.NEXT_PAGE:{pageManager.showNextPage(); break;}
            case Command.PREVIOUS_PAGE :{pageManager.showPreviousPage(); break;}
            case Command.INSERT_NEW_PAGE:{pageManager.insertNewPage(); break;}
            case Command.DELETE_PAGE :{pageManager.deletePage(); break;}
            case Command.PAGE_SETUP: {
                DialogOfPageSetup dialog=new DialogOfPageSetup();
                dialog.showDialog();
                break;
            }
            case Command.PAGE_LAYOUT: {
                DialogOfPageLayout dialog=new DialogOfPageLayout();
                dialog.showDialog(); 
                break;
            }
            
            case Command.PRINT: {fileIO.printOut(); break;}
            case Command.EXIT: {fileIO.exit(); break;}
            
            case Command.EDIT: {
                Object[] object=command.getParams();
                String menuItem=(String)object[0];
                if(Command.getCommandId(menuItem)==Command.CUT) edit.cut();
                if(Command.getCommandId(menuItem)==Command.COPY) edit.copy();
                if(Command.getCommandId(menuItem)==Command.PASTE) edit.paste();
                if(Command.getCommandId(menuItem)==Command.DEL) edit.delete();
                if(Command.getCommandId(menuItem)==Command.SELECT_ALL) {
                    ShapeContainer[] containers=containerManager.getContainers();
                    for(int i=0;i<containers.length;i++) containers[i].setSelected(true);
                }
                break;
            }
            case Command.CUT: {edit.cut();break;}
            case Command.COPY: {edit.copy(); break;}
            case Command.PASTE: {edit.paste(); break;}
            case Command.DEL : {edit.delete(); break;}
            case Command.DELETE : {edit.delete(); break;}
            case Command.SELECT_ALL: {
                ShapeContainer[] containers=containerManager.getContainers();
                for(int i=0;i<containers.length;i++) containers[i].setSelected(true);
                break;
            }
            
            case Command.UNDO : {
                UndoDrawManager undoDrawManager=ObjectTable.getUndoDrawManager("exec");
                undoDrawManager.undo(); 
                break;
            }
            
            case Command.REDO: {
                UndoDrawManager undoDrawManager=ObjectTable.getUndoDrawManager("exec");
                undoDrawManager.redo(); 
                break;
            }
            
            case Command.CLICKEDPOINT : {
                Object[] object=command.getParams();
                this.clickedPoint=(Point2D)object[0];
                //System.out.println("clickedPoint command executed  point: "+Util.Pt(this.clickedPoint));
                break;
            }
            
            case Command.TEXTBOX:
            case Command.RECTANGLE:
            case Command.ROUND_RECTANGLE:
            case Command.ELLIPSE:
            case Command.LINE:
            case Command.ARROW:
            case Command.DOUBLE_ARROW:
            case Command.POLYLINE:
            case Command.CUBIC_CURVE:
            case Command.COMPONENT_SHAPE:
            case Command.SHAPE: {
                if(callFrom==Command.callFromMenu) {
                    selectionLS=ObjectTable.getSelectionLS("ExecCommand");
                    selectionLS.selectAll(false);
                    CreateShapeLS createShapeLS=new CreateShapeLS();
                    createShapeLS.creatingStart(commandId);
                    this.activeCreateShapeLS=createShapeLS;
                    drawPanel.repaint("ExecCommand.Shape");
                }
                if(callFrom==Command.callFromMouseListener){
                    this.activeCreateShapeLS=null;
                    if(debug>0) System.out.println("** ExecCommand CreateShapeLS end");
                }
                break;
            } //Command.SHAPE

            case Command.AUX:{
                Object[] object=command.getParams();
                String menuItem=(String)object[0];

                if(Command.getCommandId(menuItem)==Command.CENTER_LINE) {
                    CreateAuxShape createAuxShape=ObjectTable.getCreateAuxShape();
                    ShapeContainer[] containers=containerManager.getSelectedContainers();
                    createAuxShape.centerLine(containers);
                }

                if (Command.getCommandId(menuItem) == Command.LINE_BISECTOR) {
                    CreateAuxShape createAuxShape=ObjectTable.getCreateAuxShape();
                    ShapeContainer[] containers=containerManager.getSelectedContainers();
                    createAuxShape.lineBisector(containers);
                }

                if(Command.getCommandId(menuItem)==Command.ANGLE_BISECTOR) {
                    CreateAuxShape createAuxShape=ObjectTable.getCreateAuxShape();
                    ShapeContainer[] containers=containerManager.getSelectedContainers();
                    createAuxShape.angleBisector(containers);
                }
                drawPanel.repaint("ExecCommand.Util");
                break;
            }

            case Command.LIB: {
                ComponentLibDialog libDialog=ObjectTable.getComponentLibDialog();
                libDialog.showDialog();
                break;
            }

            case Command.MOVE: {
                if(debug>0) System.out.println("  -->ExecCommand move");
                if(callFrom==Command.callFromMousePositionLS||
                   callFrom==Command.callFromSelectionLS) {
                    MousePositionInfo info=(MousePositionInfo)params[0];
                    MouseEvent event=(MouseEvent)params[1];
                    containerManager.makeAllTextBoxesUneditable();
                    ObjectTable.getAutoAlignLS().start(info, event);
                    break;
                }
                break;
            } //Command.MOVE

            case Command.RESIZE: {
                if(debug>0) System.out.println("  -->ExecCommand resize");
                if(callFrom==Command.callFromMousePositionLS||
                   callFrom==Command.callFromSelectionLS) {
                    MousePositionInfo info=(MousePositionInfo)params[0];
                    MouseEvent event=(MouseEvent)params[1];
                    containerManager.makeAllTextBoxesUneditable();
                    //AutoAlignLS moveReizeShapeLS=new MoveResizeShapeLS();
                    ObjectTable.getAutoAlignLS().start(info, event);
                    //moveReizeShapeLS.start(info, event);
                    break;
                } if(callFrom==Command.callFromDialog){
                    Rectangle2D oldBox=(Rectangle2D)params[0];
                    Rectangle2D newBox=(Rectangle2D)params[1];
                    ShapeContainer[] containers=containerManager.getSelectedContainers();
                    for(int i=0;i<containers.length;i++){
                      //-------------------------------------------------//   
                        ConnectionUtil.moveResize(containers[i],
                                oldBox, newBox, true, true);
                      //-------------------------------------------------//  
                    }
                    break;
                }
                break;
            } //Command.RESIZE

            case Command.ADD_TEXTBOX:{
            // this block is for PopupMenu
                if(callFrom==Command.callFromMenu) {
                    ShapeContainer container = (ShapeContainer) params[1];
                    ShapeContainer[] containers=container.getGroupedSingleShapeContainers();
                    Point2D point = (Point2D) params[0];
                    this.execUtil.addTextBox(containers);
                }
                break;
            }
            case Command.DELETE_TEXTBOX:{
            // this block is for PopupMenu
                if(callFrom==Command.callFromMenu) {
                    ShapeContainer container = (ShapeContainer) params[1];
                    ShapeContainer[] containers=container.getGroupedSingleShapeContainers();
                    Point2D point = (Point2D) params[0];
                    this.execUtil.deleteTextBox(containers);
                }
                break;
            }
            case Command.MODIFY_SHAPE: {
                if (callFrom == Command.callFromMenu) {
                    ModifyShape modifyShape=new ModifyShape();
                    modifyShape.showDialog();
                }
                break;
            }

            case Command.CHANGE_SHAPE: {
                if (callFrom == Command.callFromMenu) {
                    ComponentLibDialog dialog=ObjectTable.getComponentLibDialog();
                    ChangeShapeElement changeShape = new ChangeShapeElement(dialog);
                    changeShape.start();
                }
                break;
            }

            case Command.UTIL:{
                Object[] object=command.getParams();
                String menuItem=(String)object[0];
                
                if(Command.getCommandId(menuItem)==Command.ADD_TEXTBOX) {
                    ShapeContainer[] containers=containerManager.getAllSigleShapeContainers(true);
                    this.execUtil.addTextBox(containers);
                    //break;
                }


                if (Command.getCommandId(menuItem) == Command.DELETE_TEXTBOX) {
                     ShapeContainer[] containers=containerManager.getAllSigleShapeContainers(true);
                     this.execUtil.deleteTextBox(containers);
                    //break;
                }

                if(Command.getCommandId(menuItem)==Command.TRANSLATE) {
                    Translate translate=new Translate();
                    translate.showDialog();
                    //break;
                }
                if(Command.getCommandId(menuItem)==Command.ROTATE) {
                    Rotate rotate=new Rotate();
                    rotate.showDialog();
                    //break;
                }
                if(Command.getCommandId(menuItem)==Command.FLIP) {
                    Flip flip=new Flip();
                    flip.showDialog();
                    //break;
                }
                if(Command.getCommandId(menuItem)==Command.CHANGE_SHAPE) {
                    ComponentLibDialog dialog=ObjectTable.getComponentLibDialog();
                    ChangeShapeElement changeShape=new ChangeShapeElement(dialog);
                    changeShape.start();
                    //break;
                }
                if(Command.getCommandId(menuItem)==Command.MODIFY_SHAPE) {
                    ModifyShape modifyShape=new ModifyShape();
                    modifyShape.showDialog();
                    //break;
                }
                if(Command.getCommandId(menuItem)==Command.CUT_SHAPE) {
                    CutShape cutShape=new CutShape();
                    cutShape.showDialog();
                    //break;
                }
                if(Command.getCommandId(menuItem)==Command.CONNECT_CURVES) {
                    ConnectCurves connectCurves=new ConnectCurves();
                    connectCurves.showDialog();
                    //break;
                }
                if(Command.getCommandId(menuItem)==Command.EXTEND_CURVE) {
                    ExtendCurve extendCurve=new ExtendCurve();
                    extendCurve.showDialog();
                    //break;
                }
                if(Command.getCommandId(menuItem)==Command.COMBINE) {
                    Combine combine=new Combine();
                    combine.combine();
                }
                if(Command.getCommandId(menuItem)==Command.BREAK) {
                    Combine combine=new Combine();
                    combine.breakCombine();
                }
                drawPanel.repaint("ExecCommand");
                break;
            }
            
            case Command.SETTING:{
                String commandName=Command.getCommandString(Command.SETTING);
                String str_no_direction=Command.getCommandString(Command.FREE_DIRECTION);
                String str_xy_direction=Command.getCommandString(Command.KEEP_XY_DIRECTION);
                //String str_any_direction=Command.getCommandString(Command.KEEP_ANY_DIRECTION_AND_POSITION);
                ButtonOfPulldownMenu button
                        =(ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                JMenu menu=button.getMenu();
                JCheckBoxMenuItem check_no_direction
                        =(JCheckBoxMenuItem)button.getMenuItem(menu, str_no_direction);
                JCheckBoxMenuItem check_xy_direction
                        =(JCheckBoxMenuItem)button.getMenuItem(menu, str_xy_direction);
                //JCheckBoxMenuItem check_any_direction
                //        =(JCheckBoxMenuItem)button.getMenuItem(menu, str_any_direction);
                Object[] object=command.getParams();
                String menuItem=(String)object[0];
                ActionEvent e=(ActionEvent)object[1];
                
                if(Command.getCommandId(menuItem)==Command.AUTO_ALIGN) {
                    JCheckBoxMenuItem checkBox=(JCheckBoxMenuItem)e.getSource();
                    if(checkBox.getState()) {
                        DrawParameters.AUTO_ALIGN=true;
                    } else DrawParameters.AUTO_ALIGN=false;
                }
				
                if(Command.getCommandId(menuItem)==Command.ENABLE_CONNECTOR) {
                    JCheckBoxMenuItem checkBox=(JCheckBoxMenuItem)e.getSource();
                    if(checkBox.getState()) {
                        DrawParameters.ENABLE_CONNECTOR=true;
                    } else DrawParameters.ENABLE_CONNECTOR=false;
                }

                if(Command.getCommandId(menuItem)==Command.FREE_DIRECTION) {
                    JCheckBoxMenuItem checkBox=(JCheckBoxMenuItem)e.getSource();
                    if(checkBox.getState()) {
                        DrawParameters.AUTO_TRACKING_OPTION=Command.FREE_DIRECTION;
                    }
                }
                if(Command.getCommandId(menuItem)==Command.KEEP_XY_DIRECTION) {
                    JCheckBoxMenuItem checkBox=(JCheckBoxMenuItem)e.getSource();
                    if(checkBox.getState()) {
                        DrawParameters.AUTO_TRACKING_OPTION=Command.KEEP_XY_DIRECTION;
                    }
                }
                
                if(Command.getCommandId(menuItem)==Command.HIGHLIGHTING_FOR_SELECTION) {
                    JCheckBoxMenuItem checkBox=(JCheckBoxMenuItem)e.getSource();
                    if(checkBox.getState()) {
                        DrawParameters.ENABLE_HIGHLIGHTING=true;
                    } else DrawParameters.ENABLE_HIGHLIGHTING=false;
                }
                
                if(Command.getCommandId(menuItem)==Command.DRAW_NODE_POINTS) {
                    JCheckBoxMenuItem checkBox=(JCheckBoxMenuItem)e.getSource();
                    if(checkBox.getState()) {
                        DrawParameters.DRAW_NODE_POINTS=true;
                        DrawParameters.DRAW_CHARACTERISTIC_POINTS=false;
                    } else DrawParameters.DRAW_NODE_POINTS=false;
                }
                drawPanel.repaint("ExecCommand.Util");
                break;
            }
 
            case Command.SHAPE_FORMAT:{
                //Point point=(Point)params[0];
                ShapeContainer container=(ShapeContainer)params[1];
                DialogOfShapeFormat dialog=new DialogOfShapeFormat();
                dialog.showDialog(container);
                break;
            }

            case Command.DRAW_PANEL_INFORMATION:{
                Point point=(Point)params[0];
                DialogOfDrawPanel dialog=new DialogOfDrawPanel();
                dialog.showDialog(point);
                break;
            }

            case Command.FONT: 
            case Command.FONT_FAMILY: {
                FontStyle menuStyle=FontStyle.getFontStyleFromMenu();
                String family=menuStyle.getFontFamily();
                if(family.equals("")||family.equals(" ")) break;
              //-----------------------------//
                FontStyle fontStyle=new FontStyle();
                fontStyle.setFontFamily(family);
                this.execUtil.setFontStyle(fontStyle);
              //-----------------------------//
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case Command.FONT_SIZE: {
                FontStyle menuStyle=FontStyle.getFontStyleFromMenu();
              //-----------------------------//
                FontStyle fontStyle=new FontStyle();
                fontStyle.setFontSize(menuStyle.getFontSize());
                this.execUtil.setFontStyle(fontStyle);
              //-----------------------------//
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case Command.BOLD: {
                FontStyle menuStyle=FontStyle.getFontStyleFromMenu();
              //-----------------------------//
                FontStyle fontStyle=new FontStyle();
                fontStyle.setBold(menuStyle.getBold());
                this.execUtil.setFontStyle(fontStyle);
              //-----------------------------//
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case Command.ITALIC: {
                FontStyle menuStyle=FontStyle.getFontStyleFromMenu();
              //-----------------------------//
                FontStyle fontStyle=new FontStyle();
                fontStyle.setItalic(menuStyle.getItalic());
                this.execUtil.setFontStyle(fontStyle);
              //-----------------------------//
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case Command.UNDERLINE: {
                FontStyle menuStyle=FontStyle.getFontStyleFromMenu();
              //-----------------------------//
                FontStyle fontStyle=new FontStyle();
                fontStyle.setUnderLine(menuStyle.getUnderLine());
                this.execUtil.setFontStyle(fontStyle);
              //-----------------------------//
                drawPanel.repaint("ExecCommand.Font");
                break;
            }

            case Command.SUBSCRIPT: {
                FontStyle menuStyle=FontStyle.getFontStyleFromMenu();
              //-----------------------------//
                FontStyle fontStyle=new FontStyle();
                fontStyle.setSuperScript(menuStyle.getSuperScript());
                this.execUtil.setFontStyle(fontStyle);
              //-----------------------------//   
                drawPanel.repaint("ExecCommand.subscript");
                break;
            }
            case Command.SUPERSCRIPT: {
                FontStyle menuStyle=FontStyle.getFontStyleFromMenu();
              //-----------------------------//
                FontStyle fontStyle=new FontStyle();
                fontStyle.setSuperScript(menuStyle.getSuperScript());
                this.execUtil.setFontStyle(fontStyle);
              //-----------------------------// 
                drawPanel.repaint("ExecCommand.superscript");
                break;
            }
            case Command.FONT_COLOR: {
                FontStyle menuStyle=FontStyle.getFontStyleFromMenu();
              //-----------------------------//
                FontStyle fontStyle=new FontStyle();
                fontStyle.setFontColor(menuStyle.getFontColor());
                this.execUtil.setFontStyle(fontStyle);
              //-----------------------------//
                drawPanel.repaint("ExecCommand.Font");
                break;
            }

            case Command.TEXTBOX_LAYOUT:{
                Insets insets=null;
                if(params[0]!=null) insets=(Insets)params[0];
                int textAlign=-1;
                if(params[1]!=null)  textAlign=((Integer)params[1]).intValue();
                double lineSpace=-1d;
                if(params[2]!=null) lineSpace=((Double)params[2]).doubleValue();
              //--------------------------------------------------//     
                this.execUtil.setTextBoxLayout(insets, textAlign, lineSpace);
              //--------------------------------------------------//     
                break;
            }
            
            case Command.TEXT_ALIGN: {
				//System.out.println("---- ExecCommand command="+command.toString());
                String parm=(String)params[0];
                int argId=Command.getCommandId(parm);
                int textAlign=0;
				if(argId==Command.TEXT_ALIGN_LEFT) textAlign=0;
                if(argId==Command.TEXT_ALIGN_CENTER) textAlign=1;
                if(argId==Command.TEXT_ALIGN_RIGHT) textAlign=2;
              //------------------------------------------//    
                this.execUtil.setTextBoxLayout(null, textAlign, -1d);
              //------------------------------------------//     
                drawPanel.repaint("ExecCommand.Text_Align");
                break;
            }

            case Command.FILL_COLOR: {
                Object[] object=command.getParams();
                Color color=null;
                String objectType=object[0].getClass().getSimpleName();
                if(objectType.equals("Color")) color=(Color)object[0];
                if(objectType.equals("String")&&object.equals("no fill")) color=null;
              //---------------------------------//  
                containerManager.undoSetupStart();
              //---------------------------------//    
                ShapeContainer[] containers=containerManager.getSelectedContainers();
                int size=0;
                if(containers!=null) size=containers.length;
                 for(int i=0;i<size;i++) {
                     containers[i].setFillColor(color);
                     containers[i].setChangeCode(UndoConstants.PAINTSTYLE);
                 }
              //---------------------------------//    
                 containerManager.undoSetupEnd();
              //---------------------------------//   
                 drawPanel.repaint("ExecCommand.fillColor");
                break;
            } //Command.FILL_COLOR
        
            case Command.LINE_COLOR: {
                Object[] object=command.getParams();
                Color color=null;
                String objectType=object[0].getClass().getSimpleName();
                if(objectType.equals("Color")) color=(Color)object[0];
                if(objectType.equals("String")&&object.equals("no line")) color=null;
              //---------------------------------//  
                containerManager.undoSetupStart();
              //---------------------------------//    
                ShapeContainer[] containers=containerManager.getSelectedContainers();
				if(debug>0) printShapeIds("** ExecCommand LINE_COLOR", containers);

                int size=0;
                if(containers!=null) size=containers.length;
				//System.out.println("   containers.length="+containers.length+", size="+size);
                 for(int i=0;i<size;i++) {
                     containers[i].setLineColor(color);
                     containers[i].setChangeCode(UndoConstants.PAINTSTYLE);
                 }
               //---------------------------------//    
                 containerManager.undoSetupEnd();
               //---------------------------------//  
                 drawPanel.repaint("ExecCommand.LineColor");
				
                break;
            } //Command.LINE_COLOR
        
            case Command.LINE_WIDTH: {
                Object[] object=command.getParams();
                String lineWidth=(String)object[0];
              ///---------------------------------//  
                containerManager.undoSetupStart();
              //---------------------------------//    
                ShapeContainer[] containers=containerManager.getSelectedContainers();
                int size=0;
                if(containers!=null) size=containers.length;
                 for(int i=0;i<size;i++) {
                     containers[i].setLineWidth(lineWidth);
                     containers[i].setChangeCode(UndoConstants.PAINTSTYLE);
                 }
              //---------------------------------//    
                 containerManager.undoSetupEnd();
              //---------------------------------//  
                 drawPanel.repaint("ExecCommand.LineWidth");
                break;
            } //Command.LINE_WIDTH
            
            case Command.LINE_STROKE: {
                Object[] object=command.getParams();
                String dashedStyle=(String)object[0];
              //---------------------------------//  
                containerManager.undoSetupStart();
              //---------------------------------//    
                ShapeContainer[] containers=containerManager.getSelectedContainers();
                int size=0;
                if(containers!=null) size=containers.length;
                for(int i=0;i<size;i++) {
                    containers[i].setLineStroke(dashedStyle);
                    containers[i].setChangeCode(UndoConstants.PAINTSTYLE);
                }
              //---------------------------------//    
                containerManager.undoSetupEnd();
              //---------------------------------//  
                drawPanel.repaint("ExecCommand.LineStroks");
                break;
            } //Command.LINE_STROKE
        
            case Command.ARROW_STYLE: {
                Object[] object=command.getParams();
                String arrowStyle=(String)object[0];
              //---------------------------------//  
                containerManager.undoSetupStart();
              //---------------------------------//    
                ShapeContainer[] containers=containerManager.getSelectedContainers();
                int size=0;
                if(containers!=null) size=containers.length;
                for(int i=0;i<size;i++) {
                    containers[i].setArrowStyle(arrowStyle);
                    containers[i].setChangeCode(UndoConstants.PAINTSTYLE);
                }
              //---------------------------------//    
                containerManager.undoSetupEnd();
              //---------------------------------//  
                drawPanel.repaint("ExecCommand.Arrow");
                break;
            } //Command.ARROW_STYLE

            case Command.Z_ORDER: {
                String parm=(String)params[0];
                int argId=Command.getCommandId(parm);
                int id=0;
                if(argId==Command.MOVE_TO_FRONT) id=0;
                if(argId==Command.MOVE_TO_BACK) id=1;
                if(argId==Command.MOVE_FORWARD) id=2;
                if(argId==Command.MOVE_BACKWARD) id=3;
              //-------------------//   
                this.execUtil.moveZorder(id);
              //-------------------//   
                break;
            }
            
            case Command.ALIGN: {
                String parm=(String)params[0];
                int argId=Command.getCommandId(parm);
                int id=0;
                if(argId==Command.ALIGN_CENTER) id=1;
                if(argId==Command.ALIGN_RIGHT) id=2;
                if(argId==Command.ALIGN_TOP) id=3;
                if(argId==Command.ALIGN_MIDDLE) id=4;
                if(argId==Command.ALIGN_BOTTOM) id=5;
              //----------------//   
                this.execUtil.align(id);
              //----------------//     
                break;
            }

            case Command.GROUP:   {
                ShapeContainer[] containers=containerManager.getSelectedContainers();
                if(containers.length<=1) return;
                containerManager.group(containers);
                break;
            }

            case Command.UNGROUP: {
                ShapeContainer[] containers=containerManager.getSelectedContainers();
                containerManager.unGroup(containers);
                break;
            }

            case Command.ZOOM: {
                DialogOfZoom zoom=new DialogOfZoom();
                zoom.showDialog(); break;
            }
            case Command.ZOOM_TO: { 
                ViewUtil viewUtil=ObjectTable.getViewUtil("");
                viewUtil.zoom(((Double)params[0]).doubleValue()); 
                break;
            }
            
            case Command.TEST: {
                Object[] object=command.getParams();
                String menuItem=(String)object[0];
                ActionEvent e=(ActionEvent)object[1];

                if(Command.getCommandId(menuItem)==Command.GEOMTEST) {
                    GeometricTest geometricTest=new GeometricTest();
                    geometricTest.showDialog();
                    //break;
                }
                if(Command.getCommandId(menuItem)==Command.DRAW_BOUNDING_BOX) {
                    String commandName=Command.getCommandString(Command.TEST);
                    String checkBox=Command.getCommandString(Command.DRAW_BOUNDING_BOX);
                    ButtonOfPulldownMenu button
                        =(ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                    JMenu menu=button.getMenu();
                    JCheckBoxMenuItem check
                        =(JCheckBoxMenuItem)button.getMenuItem(menu, checkBox);
                    DrawParameters.DRAW_BOUNDINGBOX=false;
                    if(check.isSelected()) DrawParameters.DRAW_BOUNDINGBOX=true;
                }
                if(Command.getCommandId(menuItem)==Command.DRAW_CHARACTERISTIC_PT) {
                    String commandName=Command.getCommandString(Command.TEST);
                    String checkBox=Command.getCommandString(Command.DRAW_CHARACTERISTIC_PT);
                    ButtonOfPulldownMenu button
                        =(ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                    JMenu menu=button.getMenu();
                    JCheckBoxMenuItem check
                        =(JCheckBoxMenuItem)button.getMenuItem(menu, checkBox);
                    DrawParameters.DRAW_CHARACTERISTIC_POINTS=false;
                    if(check.isSelected()) {
                        DrawParameters.DRAW_CHARACTERISTIC_POINTS=true;
                        DrawParameters.DRAW_NODE_POINTS=false;
                    }
                }
                if(Command.getCommandId(menuItem)==Command.DRAW_TEXTLAYOUT_BOUND) {
                    String commandName=Command.getCommandString(Command.TEST);
                    String checkBox=Command.getCommandString(Command.DRAW_TEXTLAYOUT_BOUND);
                    ButtonOfPulldownMenu button
                        =(ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                    JMenu menu=button.getMenu();
                    JCheckBoxMenuItem check
                        =(JCheckBoxMenuItem)button.getMenuItem(menu, checkBox);
                    DrawParameters.DRAW_TEXTLAYOUT=false;
                    if(check.isSelected()) DrawParameters.DRAW_TEXTLAYOUT=true;
                }
                if(Command.getCommandId(menuItem)==Command.UNSELECTABLE_AREAS) {
                    if(debug>0) System.out.println("** Unselectable Areas");
                    String commandName=Command.getCommandString(Command.TEST);
                    String checkBox=Command.getCommandString(Command.UNSELECTABLE_AREAS);
                    ButtonOfPulldownMenu button
                        =(ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                    JMenu menu=button.getMenu();
                    JCheckBoxMenuItem check
                        =(JCheckBoxMenuItem)button.getMenuItem(menu, checkBox);
                    DrawParameters.DRAW_UNSELECTABLEAREA=false;
                    if(check.isSelected()) DrawParameters.DRAW_UNSELECTABLEAREA=true;
                }
                if(Command.getCommandId(menuItem)==Command.CONNECTION_TEST) {
                    if(debug>0) System.out.println("** ConnectionLSTest");
                    ConnectionLSTest connectionLSTest=new ConnectionLSTest();
                    connectionLSTest.showDialog();
                }
                drawPanel.repaint("ExecCommand.test");
                break;
            }
            default : {
                System.err.println("*** Error; ExecCommand, not implemented command" +
                    ", command "+command.toString());
            }
            //
        } //switch
        drawPanel.repaint("ExecCommand.end of exec method");
      //-------------------------------------//    
        this.setPreviousCommandId(commandId);
        this.setCurrentCommandId(-1);
        
      //-------------------------------------//  
        menuUtil.resetSelectedMenuComponents();
        ShapeContainer[] containers=containerManager.getAllSigleShapeContainers(true);
      //----------------------------------------------------------------//  
        //PaintStyle.setPaintStyleToMenu(containers,"ExecCommand.exec");
      //----------------------------------------------------------------//    
    }
    
    public int getCurrentCommandId(){
        return this.currentCommandId;
    }
    
    public void setCurrentCommandId(int commandId){
        this.currentCommandId=commandId;
    }
    
    public int getPreviousCommandId(){
        return this.previousCommandId;
    }
    
    public void setPreviousCommandId(int commandId){
        this.previousCommandId=commandId;
    }
    
    public Point2D getClickedPoint(){
        return this.clickedPoint;
    }

    public void clearClickedPoint(){
        this.clickedPoint=null;
    }
	
	public void printShapeIds(String title, ShapeContainer[] containers){
		int size=containers.length;
		String str =title+"\n";
		for (int i = 0; i < size; i++) {
			if (i > 0) str += ", ";
			else str += "  ";
			str += "container[" + i + "]=" + containers[i].getShapeId();
		}
		System.out.println(str);
	}

} //class ExecCommand




