package DrawTop;
import java.awt.*;
import shape.*;
import textBox.*;
import menu.*;
import util.*;
public class ExecPopupMenu {
    
    MousePositionInfo mouseInfo;
    ShapeContainer selectedContainer=null;
    //TextBox selectedTextBox=null;
    int debug=0;
    
    public void show(Point point){
        int menuType=this.getCase();
        if(menuType==-1) return;
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        Edit edit=ObjectTable.getEdit();
        String popupMenuName="";
		if(debug>0){
			System.out.println("** ExecPopupMenu.show X,Y="+point.getX()+","+point.getY()
			+", menuType="+menuType);
		}
        switch(menuType){
            case 0:{
                if(debug>0) System.out.println("** ExecPopupMenu.show mouseInfos==null");
                popupMenuName=Command.getCommandString(Command.DRAWPANEL_POPUP_MENU);
                PopupPulldownMenu drawPanelPopupMenu
                        =(PopupPulldownMenu)menuUtil.getMenuComponent(popupMenuName);
                if(drawPanelPopupMenu==null) {
					System.out.println("*** Error  ExecPopupMenu.show drawPanelPopupMenu==null");
					return;
				}
                drawPanelPopupMenu.setEnableToAllMenuItems();
                if (!edit.hasClipboad(Edit.Shape)
                        && !edit.hasClipboad(Edit.Image)) {
                    drawPanelPopupMenu.getMenuItem("paste").setEnabled(false);
                }
              //----------------------------------// 
                drawPanelPopupMenu.show(point, null);
             //-----------------------------------// 
                break;
            }
            case 1:{
                int mode=this.selectedContainer.getMode();
                if(mode!=Command.NORMAL_MODE) break;
                popupMenuName=Command.getCommandString(Command.SHAPE_POPUP_MENU);
                PopupPulldownMenu shapePopupMenu
                        =(PopupPulldownMenu)menuUtil.getMenuComponent(popupMenuName);
                if(shapePopupMenu==null) return;
                shapePopupMenu.setEnableToAllMenuItems();
                int type=this.selectedContainer.getElement().getTypeE();
                if(this.selectedContainer.getTextBox()!=null)
                     shapePopupMenu.getMenuItem("add text box").setEnabled(false);
                if(this.selectedContainer.getTextBox()==null)
                     shapePopupMenu.getMenuItem("delete text box").setEnabled(false);
                 if(type!=Command.ROUND_RECTANGLE&&type!=Command.POLYLINE&&
                     type!=Command.CUBIC_CURVE&&type!=Command.GENERAL_CURVE)
                     shapePopupMenu.getMenuItem("modify shape").setEnabled(false);
				 if (debug >0) {
					System.out.println("** ExecPopupMenu.show case=1 ShapeContainer="
							+ this.selectedContainer.getShapeId() + ", mode=" 
							+ Command.getModeString(mode));
				}
               //--------------------------------------------------//  
                 shapePopupMenu.show(point, this.selectedContainer);
               //-------------------------------------------------//   
                break;
            }
            case 2:{
                popupMenuName=Command.getCommandString(Command.GROUP_POPUP_MENU);
                PopupPulldownMenu groupPopupMenu
                        =(PopupPulldownMenu)menuUtil.getMenuComponent(popupMenuName);
                if(groupPopupMenu==null) return;
              //-------------------------------------------------//    
                groupPopupMenu.show(point, this.selectedContainer);
              //------------------------------------------------//  
                break;
            }
            case 3: {
               int mode = this.selectedContainer.getMode();
               if (debug > 0) {
                  System.out.println("** ExecPopupMenu.show TextBox="
                          + this.selectedContainer.getShapeId() + ",mode=" + Command.getModeString(mode));
               }
               popupMenuName = Command.getCommandString(Command.TEXTBOX_POPUP_MENU);
               PopupPulldownMenu textBoxPopupMenu = (PopupPulldownMenu) menuUtil.getMenuComponent(popupMenuName);
               textBoxPopupMenu.setEnableToAllMenuItems();
               if (textBoxPopupMenu == null) {
                  System.out.println("** textBoxPopupMenu == null");
                  return;
               }
               textBoxPopupMenu.setEnableToAllMenuItems();
               TextBox textBox = this.selectedContainer.getTextBox();
               if (textBox== null) {
                  System.out.println("** textBox == null");
                  return;
               }
               if (!textBox.isEditable()) {
                  System.out.println("** textBox inactivated");
                  return;
               }
               if (!textBox.isCommittedText()||!textBox.hasSelectedText()){
                  textBoxPopupMenu.getMenuItem("copy").setEnabled(false);
                  textBoxPopupMenu.getMenuItem("cut").setEnabled(false);
                  textBoxPopupMenu.getMenuItem("delete").setEnabled(false);
               }
               
               if (!edit.hasClipboad(Edit.PlainString)&&
                       !edit.hasClipboad(Edit.AttributedString)){
                  textBoxPopupMenu.getMenuItem("paste").setEnabled(false);
               }
               //------------------------------------------------//    
                textBoxPopupMenu.show(point, this.selectedContainer);
               //------------------------------------------------//  
                break;
            }
        }
        
    } //end of show
    
    private int getCase() {
        int menuType = 0;
        MousePositionLS mousePositionLS = ObjectTable.getMousePositionLS();
        MousePositionInfo[] mouseInfos = mousePositionLS.getMousePositionInfoForSelection();
        if (mouseInfos==null||mouseInfos.length == 0) {
            return 0;
        }
        this.mouseInfo = mouseInfos[0];
        if (this.mouseInfo == null) {
            return 0;
        }
        int position = this.mouseInfo.getPosition();
        ShapeContainer container = this.mouseInfo.getContainer();
        if (!container.isSelected()) {
            return 0;
        }
        if (position < MousePositionInfo.SELECTION_BOX) return 0;
        
        if (position < MousePositionInfo.TEXTBOX_BOUNDARY) {
            if (container.getContainerType() == ShapeContainer.SHAPE) {
                menuType = 1;
                this.selectedContainer = container;
            }
            if (container.getContainerType() == ShapeContainer.GROUP) {
                menuType = 2;
                this.selectedContainer = container;
            }
        } else if (position==MousePositionInfo.INSIDE_TEXT||position==MousePositionInfo.INSIDE_TEXT){
            menuType = 3;
            this.selectedContainer = container;
            if (container.getContainerType() == ShapeContainer.GROUP) {
                this.selectedContainer = this.mouseInfo.getShapeContainerInGroup();
            }
        }
        if (debug > 0) {
            System.out.println("ExecPopupMenu.getcase  menuType=" + menuType
                    + ", MousePositionInfo=" + this.mouseInfo.toString());
        }
        return menuType;
    }

}//end of class
