/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package geomExtension;

import java.awt.*;
import java.awt.geom.*;
import java.text.*;

public class CurvePT{
    public double t;
    Point2D p=null;
    Curve2D curve=null;

    public CurvePT(double t, Point2D p){
        this.t=t;
        this.p=p;
    }

    public CurvePT(double t, Point2D p, Curve2D curve2D){
        this.t=t;
        this.p=p;
        this.curve=curve2D;
    }
    
    public double getParameter(){
        return this.t;
    }

    public Point2D getP(){
        if(this.curve!=null) this.p=curve.getP(t);
        return this.p;
    }
    
    public void setCurve(Curve2D curve2D){
        this.curve=curve2D;
    }
    
    public Curve2D getCurve(){
        return this.curve;
    }
    
    public double getDistanceToCurveEndPT(int index){
        Point2D p=this.getP();
        Point2D[] PTs=this.curve.getEndPoints();
        double dist=0d;
        if(index==0) dist=Vector2D.dist(p, PTs[0]);
        else dist=Vector2D.dist(p, PTs[1]);
        return dist;
    }
/*
    public static CurvePT selectCurvePT(Point2D p, CurvePT[] curvePTs){
        CurvePT curvePT=null;
        if(curvePTs.length==1) return curvePTs[0];
        double distMin=1.0e+4;
        int index=-1;
        for(int i=0;i<curvePTs.length;i++){
            double dist=Vector2D.dist(curvePTs[i].getP(), p);
            if(dist<distMin){
                distMin=dist;
                index=i;
            }
        }
        if(index>=0) curvePT=curvePTs[index];
        return curvePT;
    }
 */
    public String toString(){
        NumberFormat nf1 = NumberFormat.getNumberInstance();
        nf1.setMaximumIntegerDigits(4);
        nf1.setMinimumFractionDigits(2);
        NumberFormat nf2 = NumberFormat.getNumberInstance();
        nf2.setMaximumIntegerDigits(5);
        nf2.setMinimumFractionDigits(2);
        String str="";
        str+="CurvePoint t="+nf1.format(t)+
                ", p="+nf2.format(p.getX())+","+nf2.format(p.getY());
        return str;
    }
}