
package menu;

import java.awt.*;
import java.awt.font.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import DrawTop.*;
import util.*;


public class ButtonOfColorChooser extends JButton{
    ColorChooserAction action=new ColorChooserAction(this);
    //Color currentColor=null;
    public static int debug=0;

    public ButtonOfColorChooser(String commandName, String tip) {
        this.setActionCommand(commandName);
        this.addActionListener(this.action);
        this.setName(commandName);
        this.setText(" "+commandName+" ");
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
        
  }
    public ButtonOfColorChooser(String commandName, boolean setText, 
                ImageIcon imageIcon, String tip) {
        super(imageIcon);
        this.setActionCommand(commandName);
        this.addActionListener(this.action);
        this.setName(commandName);
        if(setText) setText(commandName);
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
        
  }

    public void setStandardButtonStyle() { 
        Border raisedBorder = new BevelBorder(BevelBorder.RAISED);
        this.setBorder(raisedBorder);
        this.setIconTextGap(0);
        this.setHorizontalTextPosition(SwingConstants.CENTER );
        this.setVerticalTextPosition(SwingConstants.BOTTOM );
        this.setHorizontalAlignment(CENTER);
        this.setFont(MenuConstants.MenuFont);
        this.setBackground(null);
        this.setForeground(Color.BLACK);
        this.setOpaque(true);
  }

  public static JButton createColorChooserButton(String commandName, int width,
                 String tip) {
         ButtonOfColorChooser button = new ButtonOfColorChooser(commandName, tip);
         if(width<=0){
            TextLayout textlayout=new TextLayout(commandName, MenuConstants.MenuFont, 
                  new FontRenderContext(null, false, false));
            int textWidth=(int)textlayout.getAdvance()+5;
            button.setPreferredSize(new Dimension(textWidth, MenuConstants.buttonHeight));
         } else {
            button.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
         }
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(button);
         if(debug>0) menuUtil.printMenuComponent(button);
         //System.out.println(" button size="+Util.Dim(button.getPreferredSize()));
         return button;
     }
  
  public static JButton createColorChooserButton(String commandName, boolean setText, 
                 String imageName, String tip) {
         ButtonOfColorChooser button=null;
         if(imageName==null||imageName.equals("")){
             button = new ButtonOfColorChooser(commandName, tip);
             TextLayout textlayout=new TextLayout(commandName, MenuConstants.MenuFont, 
                     new FontRenderContext(null, false, false));
             int textWidth=(int)textlayout.getAdvance()+5;
             button.setPreferredSize(new Dimension(textWidth, MenuConstants.buttonHeight));
         } else{
            ImageIcon icon=DrawImageIcon.get(imageName, MenuConstants.imageWidth, 
                    MenuConstants.imageHeight);
            button = new ButtonOfColorChooser(commandName, setText, icon, tip);
            button.setPreferredSize(new Dimension(MenuConstants.buttonWidth, MenuConstants.buttonHeight));
         }
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(button);
         if(debug>0) menuUtil.printMenuComponent(button);
         return button;
     }

} //ButtonOfColorChooser

class ColorChooserAction extends AbstractAction implements ColorSelectionListener{
    ButtonOfColorChooser buttonOfColorChooser=null;
    String commandName;
    int debug=0;
    
    public ColorChooserAction(ButtonOfColorChooser buttonOfColorChooser){
        this.buttonOfColorChooser=buttonOfColorChooser;
    }
    
    public void actionPerformed(ActionEvent e) {
        
        this.commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();

        if(debug>0) System.out.println("- ColorChooserAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);
        
        CustomColorChooserDialog dialog=ObjectTable.getCustomColorChooserDialog();
        String title="";
        if(this.commandName.equals("fill color")) title="  Command: fill color";
        if(this.commandName.equals("line color")) title="  Command: line color";
        if(this.commandName.equals("font color")) title="  Command: font color";
        dialog.commandLabel.setText(title);
        dialog.removeColorSelectionListener();
        dialog.addColorSelectionListener(this);
        dialog.showDialog(this.commandName);
        
    }//End of actionPerformed
    
    public void colorSelected(ColorSelectionEvent event) {
        Color selectedColor = event.getColor();
        if(debug>0) System.out.println("** ColorSelectionListener colorSelected event.getColor()="
                + event.getColor());
        //this.buttonOfColorChooser.setCurrentColor(selectedColor,"ButtonOfColorChooser");
        if(selectedColor==null) return;

        Object[] args = new Object[1];
        args[0] = selectedColor;
        int commandId = Command.getCommandId(this.commandName);
        if (commandId < 0) {
            System.err.println("*** Error ColorChooserAction: specified command not found;" + commandName);
            return;
        }
        if(debug>0) System.out.println("** ColorChooserAction colorSelected commandName=" + commandName);
        Command command = new Command(commandId, Command.callFromMenu, args);
        ExecCommand execCommand = ObjectTable.getExecCommand("ColorChooserAction");
        execCommand.exec(command);
    }
} // end of ColorChooserAction