
package menu;

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
import javax.swing.*;
import javax.swing.border.Border.*;

public class DrawImageIcon {

    public static ImageIcon get(String imageName, int width, int height){
        ImageIcon imageIcon=null;
        if(imageName.equals("")) return imageIcon;
        BufferedImage image=getBufferedImage(imageName);
        if(image==null) return imageIcon;
        Image newImage=image.getScaledInstance(width, height, Image.SCALE_SMOOTH);
        imageIcon=new ImageIcon(newImage);
        return imageIcon;
    }
     
    private static BufferedImage getBufferedImage(String imageName){
        File file = new File("");
        String currentPath=file.getAbsolutePath();
        String filePath=currentPath+ "/images/"+imageName;
        BufferedImage bufferedImage=null;
        try{
           bufferedImage= ImageIO.read(new File(filePath));
        }catch (IOException e){
           System.err.println("*** Error: DrawImageIcon.getImage" +
                   ", Image file not found, fileName="+imageName+"\n  e="+e);
        }
        return bufferedImage;
    }
}