package menu;

import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import DrawTop.*;
import shape.*;

public class PopupPulldownMenu extends JPopupMenu {
    PopupMenuAction menuAction=new PopupMenuAction(this);
    public Point2D point=null;
    public ShapeContainer container=null;
    static int debug=0;
    
    public PopupPulldownMenu(String commandName, String[] menuItemNames, 
            ImageIcon[] icons, String[] accelerators) {
        this.setName(commandName);
        this.setMenuItems(menuItemNames, icons, accelerators);
    }

    public void setMenuItems(String[] menuItemNames, ImageIcon[] imageIcons, 
            String[] accelerators){
        JMenuItem menuItem;
        int acceleratorWidth=24;
        int textWidthMax=0, textHeightMax=0;
        for(int i=0;i<menuItemNames.length;i++) {
             Dimension textSize=this.getTextLayoutSize(menuItemNames[i], 
                     MenuConstants.MenuItemFont);
             int textWidth=(int)textSize.getWidth();
             int textHeight=(int)textSize.getHeight();
             if(accelerators!=null&&!accelerators[i].equals("")) textWidth+=acceleratorWidth;
             if(textWidth>textWidthMax) textWidthMax=textWidth;
             if(textHeight>textHeightMax) textHeightMax=textHeight;
        }
        int marginWidth=32, marginHeight=6;
        for(int i=0;i<menuItemNames.length;i++) {
           menuItem=new JMenuItem();
           if(accelerators!=null&&!accelerators[i].equals("")){
                KeyStroke stroke = KeyStroke.getKeyStroke(accelerators[i]);
                menuItem.setAccelerator(stroke);
           }
           int imageWidth=0, imageHeight=0;
           int menuItemWidth=0;
           if(imageIcons[i]!=null){
                menuItem.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
                JLabel textLabel=new JLabel(" "+menuItemNames[i]+" ");
                textLabel.setPreferredSize(new Dimension(textWidthMax+marginWidth, 
                        textHeightMax+marginHeight));
                menuItem.add(textLabel);
                menuItemWidth+=textWidthMax+marginWidth;
                
                Image image=imageIcons[i].getImage();
                imageWidth=image.getWidth(null);
                imageHeight=image.getHeight(null);
                JLabel imageLabel=new JLabel(imageIcons[i]);
                imageLabel.setPreferredSize(new Dimension(imageWidth, imageHeight));
                menuItem.add(imageLabel);
                menuItemWidth+=imageWidth+marginWidth;
           } else{
               menuItem.setText(menuItemNames[i]);
               menuItemWidth+=textWidthMax+marginWidth;
           }
           int menuItemHeight=textHeightMax+marginHeight;
           menuItem.setPreferredSize(new Dimension(menuItemWidth, menuItemHeight));
           menuItem.setFont(MenuConstants.MenuItemFont);
           String command=Command.getCommandString(menuItemNames[i]);
           if(command.equals("")) 
               System.err.println("** Error PopupPulldownMenu.setMenuItems  " +
                       "command="+menuItemNames[i]+" not found");
           else menuItem.setActionCommand(command);
           menuItem.addActionListener(this.menuAction);
           menuItem.setName(menuItemNames[i]);
           this.add(menuItem);
        }
    }
    
    private Dimension getTextLayoutSize(String text, Font font){
        TextLayout textlayout=new TextLayout(text, font, 
                new FontRenderContext(null, false, false));
        int textWidth=(int)textlayout.getAdvance();
        int textHeight=(int)(textlayout.getAscent()+textlayout.getDescent());
        return new Dimension(textWidth, textHeight);
    }
    
    public JMenuItem getMenuItem(String menuItemName){
        Component[] components=this.getComponents();
        JMenuItem menuItem=null;
        for(int i=0;i<components.length;i++){
            menuItem=(JMenuItem)components[i];
            String name=menuItem.getName();
            if(Command.compareStrings(menuItemName, name)) break; 
        }
        if(menuItem==null) System.err.println("*** Error Pulldown.getMenuItem:" +
                " specified name not found, name="+menuItemName);
        return menuItem;
    }
     
    public void setEnableToAllMenuItems(){
        Component[] components=this.getComponents();
        for(int i=0;i<components.length;i++){
            JMenuItem menuItem=(JMenuItem)components[i];
            menuItem.setEnabled(true);
        }
    }
     
    public void show(Point2D point, ShapeContainer container){
        this.point=point;
        this.container=container;
        double scale=DrawParameters.Scale;
        int ix=(int)(scale*point.getX());
        int iy=(int)(scale*point.getY());
        this.show(ObjectTable.getDrawPanel(), ix, iy);
		if(debug>0)System.out.println("** PopupPulldownMenu.show ShapeContainer="
							+ this.container.getShapeId() + ", ix="+ix+", iy="+iy);
    }
	
	public static void createDrawPanelPopupMenu() {
		String commandName = Command.getCommandString(Command.DRAWPANEL_POPUP_MENU);
		String[] imageName = {"", ""};
		String[] menuItemNames = {"paste", "draw panel information"};
		//String[] accelerators={"ctrl V", ""};
		ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
		for (int i = 0; i < menuItemNames.length; i++) {
			itemIcons[i] = null;
			if (!imageName[i].equals("")) {
				itemIcons[i] = DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth,
						MenuConstants.menuItemImageHeight);
			}
		}
		PopupPulldownMenu popupMenu = new PopupPulldownMenu(commandName, menuItemNames, itemIcons, null);
		MenuUtil menuUtil = ObjectTable.getMenuUtil();
		menuUtil.setMenuComponent(popupMenu);
		return;
	}
	
    public static void createSingleShapePopupMenu() {
        String commandName=Command.getCommandString(Command.SHAPE_POPUP_MENU);
        //String commandName="shape popup menu";
        String[] imageName={"", "", "", "", "", "", ""};
        String[] menuItemNames={"cut", "copy", "delete", "add text box", "delete text box",
                        "modify shape",  "shape format"};
        ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
        for(int i=0;i<menuItemNames.length;i++) {
           itemIcons[i]=null;
           if(!imageName[i].equals("")){
               itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth, 
                       MenuConstants.menuItemImageHeight);
           }
        }
        PopupPulldownMenu popupMenu=new PopupPulldownMenu(commandName, menuItemNames,itemIcons, null);
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(popupMenu);
        return;
    }
    
    public static void createGroupShapePopupMenu() {
        String commandName=Command.getCommandString(Command.GROUP_POPUP_MENU);
        String[] imageName={"", "", "", ""};
        String[] menuItemNames={"cut", "copy", "delete", "shape format"};
        ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
        for(int i=0;i<menuItemNames.length;i++) {
            itemIcons[i]=null;
            if(!imageName[i].equals("")){
                itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth, 
                        MenuConstants.menuItemImageHeight);
            }
        }
        PopupPulldownMenu popupMenu=new PopupPulldownMenu(commandName, menuItemNames,itemIcons, null);
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(popupMenu);
        return;
    }
    

      public static void createTextBoxPopupMenu() {
         String commandName = Command.getCommandString(Command.TEXTBOX_POPUP_MENU);
         //String commandName="shape popup menu";
         String[] imageName = {"", "", "", "", ""};
         String[] menuItemNames = {"cut", "copy", "delete", "paste"};
         ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
         for (int i = 0; i < menuItemNames.length; i++) {
            itemIcons[i] = null;
            if (!imageName[i].equals("")) {
               itemIcons[i] = DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth,
                       MenuConstants.menuItemImageHeight);
            }
         }
         PopupPulldownMenu popupMenu = new PopupPulldownMenu(commandName, menuItemNames, itemIcons, null);
         MenuUtil menuUtil = ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(popupMenu);
         return;
    }
}

class PopupMenuAction extends AbstractAction{
    PopupPulldownMenu popupPulldownMenu=null;
	int debug=0;
    
    PopupMenuAction(PopupPulldownMenu popupPulldownMenu){
        this.popupPulldownMenu=popupPulldownMenu;
    }
    
    public void actionPerformed(ActionEvent e) {
        //int debug=MenuUtil.debug;
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- PopupMenuAction.actionPerformed" +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);

        Object[] args=new Object[2];
        args[0]=this.popupPulldownMenu.point;
        args[1]=this.popupPulldownMenu.container;
		if (debug > 0) {
			System.out.println("- Step1 PopupMenuAction.actionPerformed"
					+ " commandName=" + commandName
					+ ", args[0]=" + args[0].getClass().getSimpleName() 
					+ ", args[1]=" + args[1].getClass().getSimpleName());
		}
        int commandId=Command.getCommandId(commandName);
        if(commandId<0){
            System.err.println("*** Warning PopupMenuAction: specified command not found;"+commandName);
            return;
        }
		if (debug > 0) {
			System.out.println("- Step2 PopupMenuAction.actionPerformed"
					+ " commandName=" + commandName + ", commandId=" + commandId
					/*+ "\n  - args[0]=" + args[0].toString() + "\n  - args[1]=" + args[1].toString()*/);
		}
        Command command=new Command(commandId, Command.callFromMenu, args);
        ExecCommand execCommand=ObjectTable.getExecCommand("PopupMenuAction");
		if (debug > 0) {
			System.out.println("- Step3 PopupMenuAction.actionPerformed"
					+ " command:\n  " /*+ command.toString()*/);
		}
        execCommand.exec(command);
    }//End of actionPerformed
}