package shape;

import DrawTop.*;

public class BlinkingShape implements Runnable {
    DrawPanel drawPanel = null;
    private volatile Thread blinker = null;
    private int blinkingInterval = 250;
    private boolean isVisible=true;
    
    public BlinkingShape(DrawPanel drawPanel) {
        this.drawPanel = drawPanel;
    }
    
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (blinker == thisThread) {
            try {
                thisThread.sleep(this.blinkingInterval);
            } catch (InterruptedException e) {
                System.out.println("BlinkingShape.run InterruptedException e="+e);
            }
            this.drawPanel.repaint();
            this.isVisible=!this.isVisible;
            //System.out.println("BlinkingShape.run isVisible="+this.isVisible);
        }
    }
    
    public void startBlinking() {
        if (blinker == null) {
            blinker = new Thread(this);
            blinker.start();
            this.isVisible=true;
        }
    }

    public void stopBlinking() {
        Thread tmpBlinker = blinker;
        blinker = null;
        if (tmpBlinker != null) {
            tmpBlinker.interrupt();
        }
        this.isVisible=false;
    }
    
    public boolean isVisible(){
        return this.isVisible;
    }
}