
package shapeUtil;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.Border.*;
import DrawTop.*;
import shape.*;
import geomExtension.*;
import util.*;


public class ConnectCurves extends JDialog implements SelectionListener{
    ConnectCurvesAction action=null;
    JLabel instructionLabel=null;
    JLabel messageLabel1=null;
    JLabel messageLabel2=null;
    JButton goButton=null;
    JButton repeatButton=null;
    JButton cancelButton=null;
    Vector shapeVector=new Vector();
    Color warningColor=new Color(255,0,153);
    int debug=0;
    
    public ConnectCurves(){
        super(ObjectTable.getDrawMain(), "connect curves");
        this.setName("connect curves");  
        this.action=new ConnectCurvesAction(this);
        this.createDialog();
    }
    
    public void createDialog(){
//set dialog position
        Component owner=this.getOwner();
        Point centerP=new Point(owner.getX()+10, owner.getY()+80);
        this.setLocation(centerP);
       //set window listener 
        this.addWindowListener(this.action);
        SelectionLS selectionLS=ObjectTable.getSelectionLS("connectCurves");
      //------------------------------------------//  
        selectionLS.addSelectionListener(this);
      //------------------------------------------//
        Container contentPane=this.getContentPane();
        Box box=Box.createVerticalBox();
        contentPane.add(box);

        JPanel messagePanel=new JPanel();
        messagePanel.setBorder(BorderFactory.createTitledBorder("message:"));
        Dimension messagePanelSize=new Dimension(300,80);
        messagePanel.setPreferredSize(messagePanelSize);
        GridLayout basePanelLayout=new GridLayout(3,1);
        basePanelLayout.setHgap(20);
        basePanelLayout.setVgap(5);
        messagePanel.setLayout(basePanelLayout);
        JLabel instructionLabel=new JLabel(" Connect curves.  Click curve !");
        this.messageLabel1=new JLabel(" ");
        this.messageLabel2=new JLabel(" ");
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel1);
        messagePanel.add(this.messageLabel2);
        Dimension messageDimension=new Dimension(300, 14);
        this.messageLabel1.setPreferredSize(messageDimension);
        this.messageLabel2.setPreferredSize(messageDimension);
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel1);
        messagePanel.add(this.messageLabel2);
        
    //OK, Cancel Button    
        JPanel buttonPanel=new JPanel();
        this.goButton=new JButton("Go !");
        this.goButton.setActionCommand("Go");
        this.goButton.setEnabled(false);
        this.repeatButton=new JButton("Repeat");
        this.repeatButton.setActionCommand("Repeat");
        this.repeatButton.setEnabled(false);
        this.cancelButton=new JButton("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        
        this.goButton.addActionListener(action);
        this.repeatButton.addActionListener(action);
        this.cancelButton.addActionListener(action);
        buttonPanel.add(this.goButton);
        buttonPanel.add(this.repeatButton);
        buttonPanel.add(this.cancelButton);
// layout the dialog
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
    }
    
    public void showDialog(){
        this.pack();
        this.setVisible(true);

        ContainerManager manager=ObjectTable.getContainerManager("");
      //---------------------------------------------------------//  
        this.shapeVector.clear();
        ShapeContainer[] containers=manager.getSelectedContainers();
        int size=0;
        if(containers!=null) size=containers.length;
        for(int i=0;i<size;i++ ) containers[i].setSelected(false);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint();
      //-----------------------------------------------------------//
        return;
    }

    public void showMessage(String message, Color color){
        this.messageLabel1.setForeground(color);
        this.messageLabel2.setForeground(color);
        this.messageLabel1.setFont(DrawParameters.Font12Bold);
        this.messageLabel2.setFont(DrawParameters.Font12Bold);
        int index=message.indexOf("\n");
        String str1=message;
        String str2="";
        if(index>0){
            str1=message.substring(0, index);
            if(index+1<message.length()){
                str2=message.substring(index+1, message.length());
            }
        }
        this.messageLabel1.setText(str1);
        this.messageLabel2.setText(str2);
    }

    public void selected(SelectionEvent event){
        Point2D point=event.getClickedPoint();
        ShapeContainer[] containers=event.getSelectedContainers();
        int len=containers.length;
        if(len>1){
            showMessage("  Error.  Select one by one!.", Color.RED);
            return;
        }
        ShapeContainer container=containers[0];
        if(this.debug>0) System.out.println("selected curve  container="+container+", point="+point);
      //check shape type
        if(!this.isSuitable(container)) return;
            
        String str="curve - "+(this.shapeVector.size()+1);
        DrawShapeUtil.drawTempShape("ConnectCurves", point,
                DrawParameters.Mark_SmallSize, str, Color.RED);
  
        if(this.shapeVector.size()==0) showMessage(" Accepted.  Click next curve.", Color.BLUE);
        if(this.shapeVector.size()>=1) showMessage(" Accepted.  Click next curve or Go !", Color.BLUE);
        if(this.shapeVector.size()>=1&&isDuplicated(container)>=0){
            showMessage("  Accepted.  Click next curve or Go !"
                    + "\n  warning! Selected curve is already selected !", this.warningColor);
        }       
      // save ClickedData
        MouseHitShape clickedShape=new MouseHitShape(container, point);
        this.shapeVector.add(clickedShape);
        if(this.shapeVector.size()>=2) this.goButton.setEnabled(true);
    }
    
    private boolean isSuitable(ShapeContainer container){
        boolean suitable=true;
        if(container.getContainerType()==ShapeContainer.GROUP){
            showMessage(" Error: Group was clicked, Click again !", Color.RED);
            suitable=false;
        }
        ShapeElement shapeElement=container.getElement();
        int type=container.getElement().getTypeE();
        if(type<Command.LINE||type>Command.GENERAL_CURVE){
            showMessage(" Error: Not curve, Click again !", Color.RED);
            suitable=false;
        }
        if(type>=Command.LINE&&type<=Command.GENERAL_CURVE&&shapeElement.isClosed()){
            showMessage(" Error: Closed curve, Click again! ", Color.RED);
            suitable=false;
        }
        return suitable;
    }
    
    private int isDuplicated(ShapeContainer container){ 
        int size=this.shapeVector.size();
        int isave=-1;
        for(int i=0;i<size;i++){
            MouseHitShape clickedShape=(MouseHitShape)this.shapeVector.get(i);
            String id=clickedShape.getShapeContainer().getShapeId();
            if(container.getShapeId().equals(id)){
                isave=i;
                break;
            }
        }
        return isave;
    }
    
    public MouseHitShape[] getClickedShapes(){
        int size=this.shapeVector.size();
        MouseHitShape[] shapes=new MouseHitShape[size];
        for(int i=0;i<size;i++){
            shapes[i]=(MouseHitShape)this.shapeVector.get(i);
        }
        return shapes;
    }

    public ShapeContainer[] getSelectedCurves(){
        Vector vector=new Vector();
        int size=this.shapeVector.size();
        for(int i=0;i<size;i++){
            MouseHitShape clickedShape=(MouseHitShape)this.shapeVector.get(i);
            ShapeContainer container=clickedShape.getShapeContainer();
            int index=vector.indexOf(container);
            if(index<0) vector.add(container);
        }
        size=vector.size();
        ShapeContainer[] containers=new ShapeContainer[size];
        for(int i=0;i<size;i++) containers[i]=(ShapeContainer)vector.get(i);
        return containers;
    }
    
    private void closeDialog(){
        this.setVisible(false);
      // clear mark and "selected" on the selected curve
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
      //------------------------------------------// 
        DrawShapeUtil.clearTempShape("ConnectCurves");
        drawPanel.repaint("ConnectCurves");
      //------------------------------------------// 
        this.setVisible(false);
      //-----------------------------------------------------//  
        SelectionLS selectionLS=ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this);
      //-----------------------------------------------------//
        return;
    }
    
    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        if(this.debug>=0)System.out.println("CutShape windowClosing");
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
} //end of CutShapeUtil

class ConnectCurvesAction extends AbstractAction  implements WindowListener {
    ConnectCurves dialog=null;
    int debug=0;
    
    public ConnectCurvesAction(ConnectCurves dialog){
        this.dialog=dialog;
    }
    public void actionPerformed(ActionEvent e) {
        //int debug=MenuUtil.debug;
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- ConnectCurvesAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);

        if(commandName.equals("Go")){
            MouseHitShape[] clickedShapes=this.dialog.getClickedShapes();
            if(clickedShapes==null||clickedShapes.length==0){
                this.dialog.showMessage(" No curve selected. Click curve !", Color.RED);
                return;
            }
            int returnCode=this.connect();
            if(returnCode>=0) {
                this.dialog.showMessage(" Succeeded !", Color.BLUE);
            }
            this.endProcess();
            
        }
        if(commandName.equals("Repeat")){
            this.dialog.showMessage("", Color.BLUE);
            this.repeatProcess();
        }
        if(commandName.equals("Cancel")){
            closeDialog();
        }
    }//End of actionPerformed
    
    private int connect(){
        int returnCode=0;
        Vector connectionVector=new Vector();
       //-------------------------------------------------//   
        this.getConnectionPTs(connectionVector);
       //-------------------------------------------------//  
        this.dialog.showMessage(" Show Connection Points. Go or Cancel !", Color.BLUE);
        returnCode=this.checkConnectionPTs(connectionVector);
        if(returnCode<0){
            this.dialog.goButton.setEnabled(false);
            return returnCode;
        }   
        ObjectTable.getDrawPanel().repaint("connect curves");
       //----------------------------------------------------------------------//
        ShapeContainer connectedShape=this.createConnectedCurve(connectionVector);
       //----------------------------------------------------------------------//
        if(connectedShape==null){
            return -2;
        }
        ContainerManager containerManager=ObjectTable.getContainerManager("");
       //----------------------------------//
        containerManager.undoSetupStart();
       //----------------------------------//
        connectedShape.setNewShapeId(containerManager, true);
        containerManager.addContainer(connectedShape);
        ShapeContainer[] containers=this.dialog.getSelectedCurves();
        for(int i=0;i<containers.length;i++){
            containerManager.deleteContainer(containers[i]);
        }
      //--------------------------------//  
        containerManager.undoSetupEnd();
      //--------------------------------//
        this.dialog.goButton.setEnabled(false);
        connectedShape.setSelected(true);
        return returnCode;
    }
    
    private void getConnectionPTs(Vector connectionVector){
        MouseHitShape[] clickedShapes=this.dialog.getClickedShapes();
        if(debug>0) System.out.println("ConnectCurvesAction.connectCurves");
        int size=0;
        if(clickedShapes!=null) size=clickedShapes.length;
        for(int i=0;i<size;i++){
            if(size==2&&i==(size-1)) continue;
            int next=i+1;
            if(next==size) next=0;
            ShapeContainer target1=clickedShapes[i].getShapeContainer();
            ShapeContainer target2=clickedShapes[next].getShapeContainer();
            double tolerance=DrawParameters.ConnectionTolerance;
           //-------------------------------------------------------------------------// 
            this.calculateConnectionPTs(target1, target2, tolerance, connectionVector);
           //-------------------------------------------------------------------------//  
            target1.setSelected(false);
            target2.setSelected(false);
        } //for i
    }
    
    private void calculateConnectionPTs(ShapeContainer target1, 
            ShapeContainer target2, double tolerance, Vector connectionVector){
        Curve2D curve1=target1.getElement().getCurve2D();
        Curve2D curve2=target2.getElement().getCurve2D();
       //---------------------------------------------------------------------// 
        CrossCurvePT[] crossPs=Curve2DUtil.getIntersectionPts(curve1, curve2);
       //---------------------------------------------------------------------//  
        if(crossPs!=null&&crossPs.length>0) {
            for(int i=0;i<crossPs.length;i++){
                Connection connection=new Connection(target2, target1, 
                        crossPs[i].getParameterT2(), crossPs[i].getParameterT1());
                connectionVector.add(connection);
            }
            return;
        }
        ShapeContainer container1=null;
        ShapeContainer container2=null;
        double distMin=1e+5;
        Connection connectionSave=null;
        for(int i=0;i<2;i++){
            if(i==0){
                container1=target1;
                container2=target2;
            } else{
                container1=target2;
                container2=target1;
            }
            curve1=container1.getElement().getCurve2D();
            curve2=container2.getElement().getCurve2D();
            int numseg=curve1.getNumOfSegments();
            for(int j=0;j<2;j++){
                double t=0;
                if(j==1) t=numseg;
                Point2D PT=curve1.getP(t);
               //---------------------------------------------------// 
                CurvePT curvePT=Curve2DUtil.getShortestLine(PT, curve2);
               //---------------------------------------------------// 
                if(curvePT==null) continue;
                double dist=Vector2D.dist(PT, curvePT.getP());
                if(dist>distMin) continue;
                distMin=dist;
                connectionSave=new Connection(container2, container1, 
                        curvePT.getParameter(), t);
            } //for j
        } //for i
        if(connectionSave!=null&&distMin<tolerance) {
            connectionVector.add(connectionSave);
        }
    }
    
    private int checkConnectionPTs(Vector connectionVector){
        int returnCode=0;
        MouseHitShape[] clickedShapes=this.dialog.getClickedShapes();
        if(debug>0) System.out.println("ConnectCurvesAction.connectCurves");
        int size=0;
        if(clickedShapes!=null) size=clickedShapes.length;
        for(int i=0;i<size;i++){
            if(size==2&&i==(size-1)) continue;
            int next=i+1;
            if(next==size) next=0;
            ShapeContainer target1=clickedShapes[i].getShapeContainer();
            ShapeContainer target2=clickedShapes[next].getShapeContainer();
            Connection[] connections=this.getConnections(target1, 
                    target2, connectionVector);
            if(size>=3&&connections.length>=2){
                this.dialog.showMessage(" Error: Curve-"+(i+1)+
                        ", "+(next+1)+" has multiple connection points !", Color.RED);
                if(debug>0){
                    for(int j=0;j<connections.length;j++){
                        System.out.println(" ** checkConnectionPTs"+connections[j].toString());
                    }
                }
                returnCode=-1;
                break;
            }
            if(size==2&&connections.length>=3){
                this.dialog.showMessage(" Error: Curve-"+(i+1)+
                        ", "+(next+1)+" has too many connection points !", Color.RED);
                if(debug>0){
                    for(int j=0;j<connections.length;j++){
                        System.out.println(" ** checkConnectionPTs"+connections[j].toString());
                    }
                }
                returnCode=-1;
                break;
            }
        } //for i
        if(returnCode<0){
        //draw mark at connection points  
            for(int i=0;i<connectionVector.size();i++){
                Connection connection=(Connection)connectionVector.get(i);
                double markSize=DrawParameters.Mark_SmallSize;
                DrawShapeUtil.drawTempShape("ConnectCurves",connection.getConnectorPT(), markSize, "", Color.BLUE);
                DrawShapeUtil.drawTempShape("ConnectCurves",connection.getTargetPT(),markSize, "", Color.BLUE);
            }
        }
        ObjectTable.getDrawPanel().repaint("ConnectCurves");
        return returnCode;
    }

    private Connection[] getConnections(ShapeContainer target1, 
            ShapeContainer target2, Vector connectionVector){
        Vector out=new Vector();
        int size=connectionVector.size();
        for(int i=0;i<size;i++){
            Connection connection=(Connection)connectionVector.get(i);
            ShapeContainer connector=connection.getConnector();
            ShapeContainer target=connection.getTarget();
            if(connector==target1&&target==target2) out.add(connection);
            if(connector==target2&&target==target1) {
                Connection newConnection=new Connection(connection.getConnector(),
                        connection.getTarget(), connection.getConnectorParameter(), 
                        connection.getTargetParameter());
                out.add(newConnection);
            }
        }
        Connection[] connections=new Connection[out.size()];
        for(int i=0;i<out.size();i++){
            connections[i]=(Connection)out.get(i);
        }
        return connections;
    }
    
    private Connection[] getConnections(ShapeContainer target, Vector connectionVector){
        Vector out=new Vector();
        int size=connectionVector.size();
        for(int i=0;i<size;i++){
            Connection connection=(Connection)connectionVector.get(i);
            ShapeContainer Connector=connection.getConnector();
            ShapeContainer Target=connection.getTarget();
            if(Connector==target) out.add(connection);
            if(Target==target) {
                Connection newConnection=new Connection(connection.getConnector(), 
                        connection.getTarget(),connection.getConnectorParameter(), 
                        connection.getTargetParameter());
                out.add(newConnection);
            }
        }
        Connection[] connections=new Connection[out.size()];
        for(int i=0;i<out.size();i++){
            connections[i]=(Connection)out.get(i);
        }
        return connections;
    }
    
    private ShapeContainer createConnectedCurve(Vector connectionVector){
        MouseHitShape[] clickedShapes=this.dialog.getClickedShapes();
        if(debug>0) System.out.println("ConnectCurvesAction.connectCurves");
        int size=0;
        if(clickedShapes!=null) size=clickedShapes.length;
        //GeneralCurve2DE[] trimmedCurves=new GeneralCurve2DE[size];
        Curve2D[] trimmedCurves=new Curve2D[size];
        //GeneralCurve2DE[] trimmedCurves=new GeneralCurve2DE[size];
        ShapeContainer[] containers=new ShapeContainer[size];
        for(int i=0;i<size;i++){
            ShapeContainer container=clickedShapes[i].getShapeContainer();
            containers[i]=container;
            double clickedT=clickedShapes[i].getCurveParameter();
            double[] interval=this.getCurveInterval(container, clickedT, connectionVector);
            Curve2D curve=container.getElement().getCurve2D();
            trimmedCurves[i]=Curve2DUtil.trimCurve2D(curve, interval[0], interval[1]);
        } //for i
        Curve2D connectedCurve=
                this.createConnectedCurve2D(trimmedCurves[0], trimmedCurves[1]);
        for(int i=2;i<size;i++){
            connectedCurve=this.createConnectedCurve2D(connectedCurve, trimmedCurves[i]);
        }
        if(debug>0) {
            System.out.println("createConnectedCurve connectedCurve : "
                +connectedCurve.toString());
        }
        ShapeElement connectedElement=null;
        if(connectedCurve.getType2DE()==Command.LINE) connectedElement=new LineElement();
        if(connectedCurve.getType2DE()==Command.POLYLINE) connectedElement=new PolylineElement();
        if(connectedCurve.getType2DE()==Command.CUBIC_CURVE) connectedElement=new CubicCurveElement();
        if(connectedCurve.getType2DE()==Command.GENERAL_CURVE) connectedElement=new GeneralCurveElement();
        if(connectedElement==null){
            System.err.println("*** Error in ConnectCurves : Null connected curve !");
            return null;
        }
        connectedElement.setCurve2D(connectedCurve);
        ShapeContainer connectedShape=new ShapeContainer();
        connectedShape.setElement(connectedElement);
        connectedElement.setShapeContainer(connectedShape);
        PaintStyle commonStyle=PaintStyle.getCommonPaintStyle(containers);
        connectedShape.setPaintStyle(commonStyle);
        if(debug>0) {
            System.out.println("createConnectedCurve connectedShape : "
                +connectedShape.toString());
        }
        return connectedShape;
    }
    
    private Curve2D createConnectedCurve2D(Curve2D trimmedCurve1,
            Curve2D trimmedCurve2){
        Point2D[] endP1=new Point2D[2];
        endP1[0]=trimmedCurve1.getP(0);
        endP1[1]=trimmedCurve1.getP(trimmedCurve1.getNumOfSegments());
        Point2D[] endP2=new Point2D[2];
        endP2[0]=trimmedCurve2.getP(0);
        endP2[1]=trimmedCurve2.getP(trimmedCurve2.getNumOfSegments());  
        double distMin=1e+5;
        int isave=-1, jsave=-1;
        for(int i=0;i<2;i++){
            for(int j=0;j<2;j++){
                double dist=Vector2D.dist(endP1[i], endP2[j]);
                if(dist<distMin){
                    distMin=dist;
                    isave=i;
                    jsave=j;
                }
            }
        }
        Curve2D newCurve1=(Curve2D)trimmedCurve1.clone();
        Curve2D newCurve2=(Curve2D)trimmedCurve2.clone();
        if(isave==0) newCurve1.reverse();
        if(jsave==1) newCurve2.reverse();
        int numseg1=newCurve1.getNumOfSegments();
        int numseg2=newCurve2.getNumOfSegments();
      //-----------------------------------------------// 
        this.ajustCurve(newCurve2, newCurve1);
      //-----------------------------------------------// 
        Segment2D[] newSegments=new Segment2D[numseg1+numseg2];
        for(int i=0;i<numseg1;i++) newSegments[i]=newCurve1.getSegment2D(i);
        for(int i=0;i<numseg2;i++) newSegments[i+numseg1]=newCurve2.getSegment2D(i);
        GeneralCurve2DE connectedCurve=new GeneralCurve2DE(newSegments);
        Curve2D simpleCurve=Curve2DUtil.getSimpleCurve2D(connectedCurve);
        return simpleCurve;
    }
    
    private double[] getCurveInterval(ShapeContainer container, double clickedT, 
            Vector connectionVector){
        Curve2D curve=container.getElement().getCurve2D();
        Connection[] connections=this.getConnections(container, connectionVector);
        Vector work=new Vector();
        work.add(new Double(0.0d));
        work.add(new Double(curve.getNumOfSegments()));
        int size=0;
        if(connections!=null) size=connections.length;
        for(int i=0;i<size;i++){
            double connectionT=connections[i].getConnectorParameter();
            for(int j=0;j<work.size()-1;j++){
                double t1=((Double)work.get(j)).doubleValue();
                double t2=((Double)work.get(j+1)).doubleValue();
                if(connectionT>=t1&&connectionT<=t2&&
                  Math.abs(connectionT-t1)>1e-5&&Math.abs(t2-connectionT)>1e-5){
                    work.add(j+1, new Double(connectionT));
                    break;
                }
            } //for j
        } //for i
        
        String str="** getCurveInterval";
        for(int i=0;i<work.size();i++) {
            double t=((Double)work.get(i)).doubleValue();
            str+=", t="+Util.Num(t);
        }
        //System.out.println(str);
        double[] interval=null;
        for(int j=0;j<work.size()-1;j++){
            double t1=((Double)work.get(j)).doubleValue();
            double t2=((Double)work.get(j+1)).doubleValue();
            if(clickedT>=t1&&clickedT<=t2){
                interval=new double[2];
                interval[0]=t1;
                interval[1]=t2;
                break;
            }
        } //for j
        if(debug>0) System.out.println("** getCurveInterval interval="+Util.Num(interval[0])+","+
                Util.Num(interval[1]));
        return interval;
    }

    private void ajustCurve(Curve2D targetCurve, Curve2D anchorCurve){
        int numseg1=anchorCurve.getNumOfSegments();
        int numseg2=targetCurve.getNumOfSegments();
        Point2D connectionP1=anchorCurve.getP(numseg1);
        Point2D connectionP2=targetCurve.getP(0);
        Point2D anchorP=targetCurve.getP(numseg2);
        Vector2D r0=Vector2D.sub(connectionP2,anchorP);
        Vector2D r=Vector2D.sub(connectionP1,anchorP);
        Matrix2D rotationMatrix=Matrix2D.getRotationMatrix(anchorP, r0, r);
        targetCurve.transform(rotationMatrix);
        
        connectionP2=targetCurve.getP(numseg2);
        connectionP1=anchorCurve.getP(0);
        double tolerance=DrawParameters.ConnectionTolerance;
        if(Vector2D.dist(connectionP1, connectionP2)<tolerance){
            anchorP=targetCurve.getP(0);
            r0=Vector2D.sub(connectionP2,anchorP);
            r=Vector2D.sub(connectionP1,anchorP);
            rotationMatrix=Matrix2D.getRotationMatrix(anchorP, r0, r);
            targetCurve.transform(rotationMatrix);
        }
    }
    private void endProcess(){
      //--------------------------------------------------// 
        DrawShapeUtil.clearTempShape("ConnectCurves");
      //---------------------------------------------------//  
        ContainerManager manager=ObjectTable.getContainerManager("ConnectCurves");
        ShapeContainer[] containers=manager.getSelectedContainers();
        int size=0;
        if(containers!=null) size=containers.length;
        for(int i=0;i<size;i++ ) containers[i].setSelected(false);
        this.dialog.shapeVector.clear();
      //----------------------------------------------------//
        this.dialog.goButton.setEnabled(false);
        this.dialog.repeatButton.setEnabled(true);
      //----------------------------------------------------//
        SelectionLS selectionLS=ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this.dialog);
      //-----------------------------------------------------//
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }
    
    private void repeatProcess(){
      //---------------------------------------------// 
        DrawShapeUtil.clearTempShape("ConnectCurves");
      //---------------------------------------------//  
        ContainerManager manager=ObjectTable.getContainerManager("ConnectCurves");
        ShapeContainer[] containers=manager.getSelectedContainers();
        int size=0;
        if(containers!=null) size=containers.length;
        for(int i=0;i<size;i++ ) containers[i].setSelected(false);
        this.dialog.shapeVector.clear();
      //-----------------------------------------------------------//
        this.dialog.goButton.setEnabled(false);
        this.dialog.repeatButton.setEnabled(false);
      //----------------------------------------------------//
        SelectionLS selectionLS=ObjectTable.getSelectionLS("");
        selectionLS.addSelectionListener(this.dialog);
      //-----------------------------------------------------//
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }
    
    private void closeDialog(){
        this.dialog.setVisible(false);
      // clear mark and "selected" on the selected curve
      //------------------------------------------// 
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearTempShape("ConnectCurves");
      //------------------------------------------// 
        this.dialog.setVisible(false);
      //-----------------------------------------------------//  
        SelectionLS selectionLS=ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this.dialog);
      //-----------------------------------------------------//
        drawPanel.repaint("ConnectCurves");
        return;
    }

    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}

} // end of class