package shapeUtil;

import geomExtension.*;
import java.awt.geom.*;

public class DiscreteAngledLine {
    double initAngle=0.0;
    double anglePitch=0.0;
    Point2D startPT=null;
    int ctrl=0;
    int direction=-1;
    //boolean directionSet=false;
    Vector2D[] vec=null;
    
    public DiscreteAngledLine(double initAngle, double anglePitch, Point2D startPT){
        this.initAngle=initAngle;
        this.anglePitch=anglePitch;
        this.startPT=startPT;
        double pai=Math.PI;
        int num=(int)(360/anglePitch);
        this.vec=new Vector2D[num];
        for(int i=0;i<num;i++){
            double teta=(initAngle+anglePitch*i)/180*pai;
            this.vec[i]=new Vector2D(Math.cos(teta), Math.sin(teta));
        }
    }
    
    public Point2D getControlledPT(int ctrl, Point2D p){
        Point2D newPT=null;
        if(ctrl==0) this.direction=-1;
        if(ctrl>0&&this.direction<0){
            Vector2D vec0=new Vector2D(p.getX()-this.startPT.getX(), p.getY()-this.startPT.getY());
            if(Vector2D.length(vec0)==0d) {
                this.direction=-1;
            } else{
                double sprodMax=-1.0e+4;
                int maxIndex=0;
                for(int i=0;i<vec.length;i++){
                    double sprod=Vector2D.sproduct(vec0, this.vec[i]);
                    if(sprod>sprodMax) {
                        maxIndex=i;
                        sprodMax=sprod;
                    }
                }
                this.direction=maxIndex;
                //this.directionSet=true;
            }
        }
        if(this.direction==-1) {
            newPT=(Point2D)p.clone();
        }else{
            Vector2D vec0=new Vector2D(p.getX()-this.startPT.getX(), p.getY()-this.startPT.getY());
            double sprod=Vector2D.sproduct(vec0, vec[this.direction]);
            Vector2D newVec=Vector2D.multiply(sprod,vec[this.direction]);
             newPT=new Point2D.Double(this.startPT.getX()+newVec.getX(), 
                this.startPT.getY()+newVec.getY());
        }
        return newPT;
    }  

    public static Point2D getControlledPT(double initAngle, double anglePitch, 
            Point2D p0, Point2D p){
        Vector2D vec0=new Vector2D(p.getX()-p0.getX(), p.getY()-p0.getY());
        if(Vector2D.length(vec0)==0d) return (Point2D)p0.clone();
        double pai=Math.PI;
        int num=(int)(360/anglePitch);
        Vector2D[] vec=new Vector2D[num];
        for(int i=0;i<num;i++){
            double teta=(initAngle+anglePitch*i)/180*pai;
            vec[i]=new Vector2D(Math.cos(teta), Math.sin(teta));
        }
        double sprodMax=-1.0e+4;
        int maxIndex=0;
        for(int i=0;i<vec.length;i++){
            double sprod=Vector2D.sproduct(vec0, vec[i]);
            if(sprod>sprodMax) {
                maxIndex=i;
                sprodMax=sprod;
            }
        }
        Vector2D newVec=Vector2D.multiply(sprodMax,vec[maxIndex]);
        Point2D newPoint=new Point2D.Double(p0.getX()+newVec.getX(), p0.getY()+newVec.getY());
        return newPoint;
    }  
}
