/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package shapeUtil;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import DrawTop.*;
import shape.*;
import util.*;

public class ExtendCurveLS implements MouseListener, MouseMotionListener{
     ExtendCurve extendCurve=null;
     ShapeContainer shapeContainer=null;
     ConnectionUtil connectionUtil=new ConnectionUtil();
     Point2D startPoint=null; 
     Point2D endPoint=null;
     Point2D oldPoint=null;
     DiscreteAngledLine lineAngle=null;
     public static int debug=0;
     
    public ExtendCurveLS(ExtendCurve extendCurve){
        this.extendCurve=extendCurve;
    }
    
    public void start(){
        System.out.println("- ExtendCurveLS.start. SelectionLS stopped.");
        ListenerPanel listenerPanel=ObjectTable.getListenerPanel("ExtendCurveLS");
        listenerPanel.addMouseListener(this);
        listenerPanel.addMouseMotionListener(this);
        SelectionLS selectionLS=ObjectTable.getSelectionLS();
        selectionLS.end();
        DrawShapeUtil.clearTempShape("ExtendCurve");
     }

     public void end(){
        if(debug>=0) System.out.println("- ExtendCurveLS.end. SelectionLS restarted.");
        ListenerPanel listenerPanel=ObjectTable.getListenerPanel("ExtendCurveLS");
        listenerPanel.removeMouseListener(this);
        listenerPanel.removeMouseMotionListener(this);
        SelectionLS selectionLS=ObjectTable.getSelectionLS();
        selectionLS.start();
    }
     

    public void mousePressed(MouseEvent e) {
        //System.out.println("** ExtendCurveLS mousePressed");
        double scale=DrawParameters.getScale();
        double X = e.getX()/scale;
        double Y = e.getY()/scale;
        int key=e.getModifiersEx();
        int ctrl=0;
        if((key&InputEvent.SHIFT_DOWN_MASK)!=0) ctrl=1;
        if((key&InputEvent.CTRL_DOWN_MASK)!=0) ctrl=2;
        if((key&InputEvent.BUTTON2_DOWN_MASK)!=0) ctrl=3;
        if((key&InputEvent.BUTTON3_DOWN_MASK)!=0) ctrl=3;
        Point2D point=new Point2D.Double(X,Y);

        if(debug>0) System.out.println(" - ExtendCurveLS calls receive method."
                    + ", clickedPoint="+Util.Pt(point));
        this.extendCurve.receivePoint(point);
        this.end();
     }
     
    public void mouseDragged(MouseEvent e) {
        //System.out.println("** ExtendCurveLS mouseDragged");
        double scale=DrawParameters.getScale();
        double X = e.getX()/scale;
        double Y = e.getY()/scale;
        int key=e.getModifiersEx();
        int ctrl=0;
        if((key&InputEvent.SHIFT_DOWN_MASK)!=0) ctrl=1;
        if((key&InputEvent.CTRL_DOWN_MASK)!=0) ctrl=2;
    } //mouseDragged


    public void mouseReleased(MouseEvent e) {
        this.startPoint=null;
        this.endPoint=null;
        this.oldPoint=null;
    } 
    
    public void mouseClicked(MouseEvent e) {
        double scale=DrawParameters.getScale();
        double X = e.getX()/scale;
        double Y = e.getY()/scale;
    }

    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {} 
} //end of ExtendCurveLS
