package util;

import java.awt.*;
import java.awt.print.*;
import java.util.*;
import DrawTop.*;
import shape.*;

public class PrintableDrawPage implements Printable{
    ContainerManager containerManager=new ContainerManager();
    
    public PrintableDrawPage(int page){
        PageManager pageManager=ObjectTable.getPageManager("PrintableDrawPage");
        ArrayList list=pageManager.getContainerList(page);
        this.containerManager.setContainerList(list);
    }
    
    public int print(Graphics g, PageFormat pf, int pageIndex)
        throws PrinterException {
        DrawParameters.DrawMode=DrawParameters.DrawOnPrinter;
        Graphics2D g2=(Graphics2D)g;
        double scale=0.75d;
        g2.scale(scale, scale);
        ShapeContainer[] containers=this.containerManager.getContainers();
        for(int i=0;i<containers.length;i++){
            containers[i].drawShape(g);
        }
        g2.scale(1d, 1d);
        DrawParameters.DrawMode=DrawParameters.DrawOnScreen;
        return Printable.PAGE_EXISTS;
    }
}