package util;

import java.awt.*;
import java.awt.datatransfer.*;
import shape.*;

public class TransferableShapeContainer implements Transferable{

    SerializableElement[] sElements=null;
    private Image image;
    public static int debug=Edit.debug;
    
    public TransferableShapeContainer(ShapeContainer[] containers){
        this.sElements=new SerializableElement[containers.length];
        for(int i=0;i<containers.length;i++){
            SerializableElement sElm
                    =SerializableElementUtil.convertShapeContainer(containers[i]);
            this.sElements[i]=sElm;
        }
      // also creates image data.
        ScreenImage screenImage=new ScreenImage(containers);
        this.image=screenImage.getImage();
    } // end of constructor
    
//Transferable method
    public Object getTransferData(DataFlavor flavor)
        throws UnsupportedFlavorException {
        if(flavor==Edit.DrawShapeFlavor||
                flavor.equals(Edit.DrawShapeFlavor)) {
            return this.sElements;
        } if(flavor.equals(DataFlavor.imageFlavor)) {
            return this.image;   
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
    }

//Transferable method
    public DataFlavor[] getTransferDataFlavors(){
        DataFlavor[] flavors=new DataFlavor[2];
        flavors[0]=Edit.DrawShapeFlavor;
        flavors[1]=DataFlavor.imageFlavor;
        return flavors;
    }
//Transferable method
    public boolean isDataFlavorSupported(DataFlavor flavor){
        boolean supported=false;
        if(flavor==Edit.DrawShapeFlavor) supported=true;
        if(flavor==DataFlavor.imageFlavor) supported=true;
        return supported;
    }
      
} //End of class
